/*
 * Decompiled with CFR 0.152.
 */
package donky.microsoft.aspnet.signalr.client.http;

import donky.microsoft.aspnet.signalr.client.Credentials;
import donky.microsoft.aspnet.signalr.client.http.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class CookieCredentials
implements Credentials {
    private Map<String, String> mCookieValues = new HashMap<String, String>();

    public CookieCredentials() {
    }

    public CookieCredentials(String cookie) {
        if (cookie != null && !(cookie = cookie.trim()).trim().equals("")) {
            String[] keyValues = cookie.split(";");
            for (int i = 0; i < keyValues.length; ++i) {
                String[] parts = keyValues[i].split("=");
                try {
                    this.addCookie(URLDecoder.decode(parts[0], "UTF-8"), URLDecoder.decode(parts[1], "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
    }

    public void addCookie(String name, String value) {
        this.mCookieValues.put(name, value);
    }

    public void removeCookie(String name) {
        this.mCookieValues.remove(name);
    }

    @Override
    public void prepareRequest(Request request) {
        if (this.mCookieValues.size() > 0) {
            StringBuilder currentCookies = new StringBuilder();
            if (request.getHeaders().containsKey("Cookie")) {
                currentCookies.append(request.getHeaders().get("Cookie"));
                currentCookies.append("; ");
            }
            currentCookies.append(this.toString());
            request.removeHeader("Cookie");
            request.addHeader("Cookie", currentCookies.toString());
        }
    }

    public String toString() {
        if (this.mCookieValues.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String key : this.mCookieValues.keySet()) {
                try {
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    sb.append("=");
                    sb.append(URLEncoder.encode(this.mCookieValues.get(key), "UTF-8"));
                    sb.append(";");
                }
                catch (UnsupportedEncodingException e) {}
            }
            return sb.toString();
        }
        return "";
    }
}

