/*
 * Decompiled with CFR 0.152.
 */
package donky.microsoft.aspnet.signalr.client.http.java;

import donky.microsoft.aspnet.signalr.client.LogLevel;
import donky.microsoft.aspnet.signalr.client.Logger;
import donky.microsoft.aspnet.signalr.client.Platform;
import donky.microsoft.aspnet.signalr.client.http.HttpConnection;
import donky.microsoft.aspnet.signalr.client.http.HttpConnectionFuture;
import donky.microsoft.aspnet.signalr.client.http.Request;
import donky.microsoft.aspnet.signalr.client.http.java.NetworkRunnable;
import donky.microsoft.aspnet.signalr.client.http.java.NetworkThread;

public class JavaHttpConnection
implements HttpConnection {
    private static final String USER_AGENT_HEADER = "User-Agent";
    private Logger mLogger;

    public JavaHttpConnection(Logger logger) {
        this.mLogger = logger;
    }

    @Override
    public HttpConnectionFuture execute(Request request, HttpConnectionFuture.ResponseCallback callback) {
        request.addHeader(USER_AGENT_HEADER, Platform.getUserAgent());
        this.mLogger.log("Create new thread for HTTP Connection", LogLevel.Verbose);
        HttpConnectionFuture future = new HttpConnectionFuture();
        final NetworkRunnable target = new NetworkRunnable(this.mLogger, request, future, callback);
        final NetworkThread networkThread = new NetworkThread((Runnable)target){

            @Override
            void releaseAndStop() {
                try {
                    target.closeStreamAndConnection();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        future.onCancelled(new Runnable(){

            @Override
            public void run() {
                networkThread.releaseAndStop();
            }
        });
        networkThread.start();
        return future;
    }
}

