/*
 * Decompiled with CFR 0.152.
 */
package donky.microsoft.aspnet.signalr.client.transport;

import donky.microsoft.aspnet.signalr.client.ConnectionBase;
import donky.microsoft.aspnet.signalr.client.FutureHelper;
import donky.microsoft.aspnet.signalr.client.LogLevel;
import donky.microsoft.aspnet.signalr.client.Logger;
import donky.microsoft.aspnet.signalr.client.Platform;
import donky.microsoft.aspnet.signalr.client.SignalRFuture;
import donky.microsoft.aspnet.signalr.client.http.HttpConnection;
import donky.microsoft.aspnet.signalr.client.http.HttpConnectionFuture;
import donky.microsoft.aspnet.signalr.client.http.InvalidHttpStatusCodeException;
import donky.microsoft.aspnet.signalr.client.http.Request;
import donky.microsoft.aspnet.signalr.client.http.Response;
import donky.microsoft.aspnet.signalr.client.transport.ClientTransport;
import donky.microsoft.aspnet.signalr.client.transport.DataResultCallback;
import donky.microsoft.aspnet.signalr.client.transport.NegotiationException;
import donky.microsoft.aspnet.signalr.client.transport.NegotiationResponse;
import donky.microsoft.aspnet.signalr.client.transport.TransportHelper;
import java.io.IOException;

public abstract class HttpClientTransport
implements ClientTransport {
    protected static final int BUFFER_SIZE = 1024;
    protected HttpConnection mHttpConnection;
    protected boolean mStartedAbort = false;
    protected SignalRFuture<Void> mAbortFuture = null;
    private Logger mLogger;

    public HttpClientTransport(Logger logger) {
        this(logger, Platform.createHttpConnection(logger));
    }

    public HttpClientTransport(Logger logger, HttpConnection httpConnection) {
        if (logger == null) {
            throw new IllegalArgumentException("logger");
        }
        this.mHttpConnection = httpConnection;
        this.mLogger = logger;
    }

    @Override
    public SignalRFuture<NegotiationResponse> negotiate(final ConnectionBase connection) {
        this.log("Start the negotiation with the server", LogLevel.Information);
        String url = connection.getUrl() + "negotiate" + TransportHelper.getNegotiateQueryString(connection);
        Request get = new Request("GET");
        get.setUrl(url);
        get.setVerb("GET");
        get.setHeaders(connection.getHeaders());
        connection.prepareRequest(get);
        final SignalRFuture<NegotiationResponse> negotiationFuture = new SignalRFuture<NegotiationResponse>();
        this.log("Execute the request", LogLevel.Verbose);
        HttpConnectionFuture connectionFuture = this.mHttpConnection.execute(get, new HttpConnectionFuture.ResponseCallback(){

            @Override
            public void onResponse(Response response) {
                try {
                    HttpClientTransport.this.log("Response received", LogLevel.Verbose);
                    HttpClientTransport.this.throwOnInvalidStatusCode(response);
                    HttpClientTransport.this.log("Read response data to the end", LogLevel.Verbose);
                    String negotiationContent = response.readToEnd();
                    HttpClientTransport.this.log("Trigger onSuccess with negotiation data: " + negotiationContent, LogLevel.Verbose);
                    negotiationFuture.setResult(new NegotiationResponse(negotiationContent, connection.getJsonParser()));
                }
                catch (Throwable e) {
                    HttpClientTransport.this.log(e);
                    negotiationFuture.triggerError(new NegotiationException("There was a problem in the negotiation with the server", e));
                }
            }
        });
        FutureHelper.copyHandlers(connectionFuture, negotiationFuture);
        return negotiationFuture;
    }

    @Override
    public SignalRFuture<Void> send(ConnectionBase connection, String data, final DataResultCallback callback) {
        try {
            this.log("Start sending data to the server: " + data, LogLevel.Information);
            Request post = new Request("POST");
            post.setFormContent("data", data);
            post.setUrl(connection.getUrl() + "send" + TransportHelper.getSendQueryString(this, connection));
            post.setHeaders(connection.getHeaders());
            post.addHeader("Content-Type", "application/x-www-form-urlencoded");
            connection.prepareRequest(post);
            this.log("Execute the request", LogLevel.Verbose);
            HttpConnectionFuture future = this.mHttpConnection.execute(post, new HttpConnectionFuture.ResponseCallback(){

                @Override
                public void onResponse(Response response) throws Exception {
                    HttpClientTransport.this.log("Response received", LogLevel.Verbose);
                    HttpClientTransport.this.throwOnInvalidStatusCode(response);
                    HttpClientTransport.this.log("Read response to the end", LogLevel.Verbose);
                    String data = response.readToEnd();
                    if (data != null) {
                        HttpClientTransport.this.log("Trigger onData with data: " + data, LogLevel.Verbose);
                        callback.onData(data);
                    }
                }
            });
            return future;
        }
        catch (Throwable e) {
            this.log(e);
            SignalRFuture<Void> future = new SignalRFuture<Void>();
            future.triggerError(e);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignalRFuture<Void> abort(ConnectionBase connection) {
        HttpClientTransport httpClientTransport = this;
        synchronized (httpClientTransport) {
            if (!this.mStartedAbort) {
                this.log("Started aborting", LogLevel.Information);
                this.mStartedAbort = true;
                try {
                    String url = connection.getUrl() + "abort" + TransportHelper.getSendQueryString(this, connection);
                    Request post = new Request("POST");
                    post.setUrl(url);
                    post.setHeaders(connection.getHeaders());
                    connection.prepareRequest(post);
                    this.log("Execute request", LogLevel.Verbose);
                    this.mAbortFuture = this.mHttpConnection.execute(post, new HttpConnectionFuture.ResponseCallback(){

                        @Override
                        public void onResponse(Response response) {
                            HttpClientTransport.this.log("Finishing abort", LogLevel.Verbose);
                            HttpClientTransport.this.mStartedAbort = false;
                        }
                    });
                    return this.mAbortFuture;
                }
                catch (Throwable e) {
                    this.log(e);
                    this.log("Finishing abort", LogLevel.Verbose);
                    this.mStartedAbort = false;
                    SignalRFuture<Void> future = new SignalRFuture<Void>();
                    future.triggerError(e);
                    return future;
                }
            }
            return this.mAbortFuture;
        }
    }

    protected void throwOnInvalidStatusCode(Response response) throws InvalidHttpStatusCodeException {
        if (response.getStatus() < 200 || response.getStatus() > 299) {
            String responseContent;
            try {
                responseContent = response.readToEnd();
            }
            catch (IOException e) {
                responseContent = "";
            }
            StringBuilder headersString = new StringBuilder();
            for (String header : response.getHeaders().keySet()) {
                headersString.append("[");
                headersString.append(header);
                headersString.append(": ");
                for (String headerValue : response.getHeader(header)) {
                    headersString.append(headerValue);
                    headersString.append("; ");
                }
                headersString.append("]; ");
            }
            throw new InvalidHttpStatusCodeException(response.getStatus(), responseContent, headersString.toString());
        }
    }

    protected void log(String message, LogLevel level) {
        this.mLogger.log(this.getName() + " - " + message, level);
    }

    protected void log(Throwable error) {
        this.mLogger.log(this.getName() + " - Error: " + error.toString(), LogLevel.Critical);
    }
}

