/*
 * Decompiled with CFR 0.152.
 */
package donky.microsoft.aspnet.signalr.client.transport;

import donky.microsoft.aspnet.signalr.client.ConnectionBase;
import donky.microsoft.aspnet.signalr.client.ConnectionState;
import donky.microsoft.aspnet.signalr.client.ErrorCallback;
import donky.microsoft.aspnet.signalr.client.LogLevel;
import donky.microsoft.aspnet.signalr.client.Logger;
import donky.microsoft.aspnet.signalr.client.SignalRFuture;
import donky.microsoft.aspnet.signalr.client.UpdateableCancellableFuture;
import donky.microsoft.aspnet.signalr.client.http.HttpConnection;
import donky.microsoft.aspnet.signalr.client.http.HttpConnectionFuture;
import donky.microsoft.aspnet.signalr.client.http.Request;
import donky.microsoft.aspnet.signalr.client.http.Response;
import donky.microsoft.aspnet.signalr.client.transport.ConnectionType;
import donky.microsoft.aspnet.signalr.client.transport.DataResultCallback;
import donky.microsoft.aspnet.signalr.client.transport.HttpClientTransport;
import donky.microsoft.aspnet.signalr.client.transport.TransportHelper;

public class LongPollingTransport
extends HttpClientTransport {
    private UpdateableCancellableFuture<Void> mConnectionFuture;
    private Object mPollSync = new Object();

    public LongPollingTransport(Logger logger) {
        super(logger);
    }

    public LongPollingTransport(Logger logger, HttpConnection httpConnection) {
        super(logger, httpConnection);
    }

    @Override
    public String getName() {
        return "longPolling";
    }

    @Override
    public boolean supportKeepAlive() {
        return false;
    }

    @Override
    public SignalRFuture<Void> start(ConnectionBase connection, ConnectionType connectionType, DataResultCallback callback) {
        return this.poll(connection, connectionType == ConnectionType.InitialConnection ? "connect" : "reconnect", callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SignalRFuture<Void> poll(final ConnectionBase connection, final String connectionUrl, final DataResultCallback callback) {
        Object object = this.mPollSync;
        synchronized (object) {
            this.log("Start the communication with the server", LogLevel.Information);
            String url = connection.getUrl() + connectionUrl + TransportHelper.getReceiveQueryString(this, connection);
            Request get = new Request("GET");
            get.setUrl(url);
            get.setHeaders(connection.getHeaders());
            connection.prepareRequest(get);
            this.log("Execute the request", LogLevel.Verbose);
            this.mConnectionFuture = new UpdateableCancellableFuture(null);
            final HttpConnectionFuture future = this.mHttpConnection.execute(get, new HttpConnectionFuture.ResponseCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(Response response) {
                    Object object = LongPollingTransport.this.mPollSync;
                    synchronized (object) {
                        block8: {
                            try {
                                LongPollingTransport.this.throwOnInvalidStatusCode(response);
                                if (connectionUrl != "poll") {
                                    LongPollingTransport.this.mConnectionFuture.setResult(null);
                                }
                                LongPollingTransport.this.log("Response received", LogLevel.Verbose);
                                LongPollingTransport.this.log("Read response to the end", LogLevel.Verbose);
                                String responseData = response.readToEnd();
                                if (responseData != null) {
                                    responseData = responseData.trim();
                                }
                                LongPollingTransport.this.log("Trigger onData with data: " + responseData, LogLevel.Verbose);
                                callback.onData(responseData);
                                if (!LongPollingTransport.this.mConnectionFuture.isCancelled() && connection.getState() == ConnectionState.Connected) {
                                    LongPollingTransport.this.log("Continue polling", LogLevel.Verbose);
                                    LongPollingTransport.this.mConnectionFuture.setFuture(LongPollingTransport.this.poll(connection, "poll", callback));
                                }
                            }
                            catch (Throwable e) {
                                if (LongPollingTransport.this.mConnectionFuture.isCancelled()) break block8;
                                LongPollingTransport.this.log(e);
                                LongPollingTransport.this.mConnectionFuture.triggerError(e);
                            }
                        }
                    }
                }
            });
            future.onTimeout(new ErrorCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(Throwable error) {
                    Object object = LongPollingTransport.this.mPollSync;
                    synchronized (object) {
                        if (connectionUrl.equals("poll")) {
                            LongPollingTransport.this.mConnectionFuture.setFuture(LongPollingTransport.this.poll(connection, "poll", callback));
                        } else {
                            future.triggerError(error);
                        }
                    }
                }
            });
            future.onError(new ErrorCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onError(Throwable error) {
                    Object object = LongPollingTransport.this.mPollSync;
                    synchronized (object) {
                        LongPollingTransport.this.mConnectionFuture.triggerError(error);
                    }
                }
            });
            this.mConnectionFuture.setFuture(future);
            return this.mConnectionFuture;
        }
    }
}

