/*
 * Decompiled with CFR 0.152.
 */
package donky.microsoft.aspnet.signalr.client.transport;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import donky.microsoft.aspnet.signalr.client.ConnectionBase;
import donky.microsoft.aspnet.signalr.client.LogLevel;
import donky.microsoft.aspnet.signalr.client.Logger;
import donky.microsoft.aspnet.signalr.client.SignalRFuture;
import donky.microsoft.aspnet.signalr.client.UpdateableCancellableFuture;
import donky.microsoft.aspnet.signalr.client.http.HttpConnection;
import donky.microsoft.aspnet.signalr.client.transport.ConnectionType;
import donky.microsoft.aspnet.signalr.client.transport.DataResultCallback;
import donky.microsoft.aspnet.signalr.client.transport.HttpClientTransport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.util.Charsetfunctions;

public class WebsocketTransport
extends HttpClientTransport {
    private String mPrefix;
    private static final Gson gson = new Gson();
    WebSocketClient mWebSocketClient;
    private UpdateableCancellableFuture<Void> mConnectionFuture;

    public WebsocketTransport(Logger logger) {
        super(logger);
    }

    public WebsocketTransport(Logger logger, HttpConnection httpConnection) {
        super(logger, httpConnection);
    }

    @Override
    public String getName() {
        return "webSockets";
    }

    @Override
    public boolean supportKeepAlive() {
        return true;
    }

    @Override
    public SignalRFuture<Void> start(ConnectionBase connection, ConnectionType connectionType, final DataResultCallback callback) {
        URI uri;
        String connectionString = connectionType == ConnectionType.InitialConnection ? "connect" : "reconnect";
        String transport = this.getName();
        String connectionToken = connection.getConnectionToken();
        String messageId = connection.getMessageId() != null ? connection.getMessageId() : "";
        String groupsToken = connection.getGroupsToken() != null ? connection.getGroupsToken() : "";
        String connectionData = connection.getConnectionData() != null ? connection.getConnectionData() : "";
        boolean isSsl = false;
        String url = null;
        try {
            url = connection.getUrl() + connectionString + '?' + "connectionData=" + URLEncoder.encode(URLEncoder.encode(connectionData, "UTF-8"), "UTF-8") + "&connectionToken=" + URLEncoder.encode(URLEncoder.encode(connectionToken, "UTF-8"), "UTF-8") + "&groupsToken=" + URLEncoder.encode(groupsToken, "UTF-8") + "&messageId=" + URLEncoder.encode(messageId, "UTF-8") + "&transport=" + URLEncoder.encode(transport, "UTF-8");
            if (connection.getQueryString() != null) {
                url = url + "&" + connection.getQueryString();
            }
            if (url.startsWith("https://")) {
                isSsl = true;
                url = url.replace("https://", "wss://");
            } else if (url.startsWith("http://")) {
                url = url.replace("http://", "ws://");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.mConnectionFuture = new UpdateableCancellableFuture(null);
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.mConnectionFuture.triggerError(e);
            return this.mConnectionFuture;
        }
        this.mWebSocketClient = new WebSocketClient(uri, (Draft)new Draft_17(), connection.getHeaders(), 0){

            public void onOpen(ServerHandshake serverHandshake) {
                WebsocketTransport.this.mConnectionFuture.setResult(null);
            }

            public void onMessage(String s) {
                callback.onData(s);
            }

            public void onClose(int i, String s, boolean b) {
                WebsocketTransport.this.mWebSocketClient.close();
            }

            public void onError(Exception e) {
                WebsocketTransport.this.mWebSocketClient.close();
            }

            public void onFragment(Framedata frame) {
                try {
                    String decodedString = Charsetfunctions.stringUtf8((ByteBuffer)frame.getPayloadData());
                    if (decodedString.equals("]}")) {
                        return;
                    }
                    if (decodedString.endsWith(":[") || null == WebsocketTransport.this.mPrefix) {
                        WebsocketTransport.this.mPrefix = decodedString;
                        return;
                    }
                    String simpleConcatenate = WebsocketTransport.this.mPrefix + decodedString;
                    if (WebsocketTransport.this.isJSONValid(simpleConcatenate)) {
                        this.onMessage(simpleConcatenate);
                    } else {
                        String extendedConcatenate = simpleConcatenate + "]}";
                        if (WebsocketTransport.this.isJSONValid(extendedConcatenate)) {
                            this.onMessage(extendedConcatenate);
                        } else {
                            WebsocketTransport.this.log("invalid json received:" + decodedString, LogLevel.Critical);
                        }
                    }
                }
                catch (InvalidDataException e) {
                    e.printStackTrace();
                }
            }
        };
        if (isSsl) {
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            try {
                this.mWebSocketClient.setSocket(factory.createSocket());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.mWebSocketClient.connect();
        connection.closed(new Runnable(){

            @Override
            public void run() {
                WebsocketTransport.this.mWebSocketClient.close();
            }
        });
        return this.mConnectionFuture;
    }

    @Override
    public SignalRFuture<Void> send(ConnectionBase connection, String data, DataResultCallback callback) {
        this.mWebSocketClient.send(data);
        return new UpdateableCancellableFuture<Void>(null);
    }

    private boolean isJSONValid(String test) {
        try {
            gson.fromJson(test, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }
}

