/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateUtil {
    private static RestTemplate restTemplate = new RestTemplate();

    public static HttpHeaders getHeaders(HttpServletRequest request) {
        HttpHeaders requestHeaders = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            requestHeaders.add(key, value);
        }
        return requestHeaders;
    }

    public static <T> ResponseEntity<T> get(String url, Class<T> responseType) {
        return restTemplate.getForEntity(url, responseType, new Object[0]);
    }

    public static <T> ResponseEntity<T> get(String url, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.getForEntity(url, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.getForEntity(url, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, Map<String, String> headers, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.get(url, httpHeaders, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, HttpHeaders headers, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return RestTemplateUtil.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, Map<String, String> headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.get(url, httpHeaders, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> get(String url, HttpHeaders headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return RestTemplateUtil.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, Class<T> responseType) {
        return restTemplate.postForEntity(url, (Object)HttpEntity.EMPTY, responseType, new Object[0]);
    }

    public static <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType) {
        return restTemplate.postForEntity(url, requestBody, responseType, new Object[0]);
    }

    public static <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.postForEntity(url, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.postForEntity(url, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.post(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtil.post(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.post(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtil.post(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> post(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Class<T> responseType, Object ... uriVariables) {
        return RestTemplateUtil.put(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return RestTemplateUtil.put(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return RestTemplateUtil.put(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.put(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtil.put(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.put(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtil.put(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.exchange(url, HttpMethod.PUT, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> put(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.exchange(url, HttpMethod.PUT, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Class<T> responseType, Object ... uriVariables) {
        return RestTemplateUtil.delete(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return RestTemplateUtil.delete(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return RestTemplateUtil.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return RestTemplateUtil.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.delete(url, httpHeaders, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return RestTemplateUtil.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.delete(url, httpHeaders, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return RestTemplateUtil.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.delete(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtil.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return RestTemplateUtil.delete(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtil.delete(url, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.exchange(url, HttpMethod.DELETE, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> delete(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.exchange(url, HttpMethod.DELETE, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        return restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        return restTemplate.exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public static RestTemplate getRestTemplate() {
        return restTemplate;
    }
}

