/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.CityBean;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.ICityBiz;
import net.mingsoft.basic.entity.CityEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u540e\u7aef-\u57fa\u7840\u63a5\u53e3"})
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/city"})
public class CityAction
extends BaseAction {
    @Autowired
    private ICityBiz cityBiz;

    @ApiIgnore
    @ApiOperation(value="\u8fd4\u56de\u4e3b\u754c\u9762index")
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"city:view"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/basic/city/index";
    }

    @ApiOperation(value="\u8fd4\u56de\u7f16\u8f91\u754c\u9762city_form")
    @ApiImplicitParam(name="id", value="\u4e3b\u952e\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/form"})
    @RequiresPermissions(value={"city:view"})
    @ApiIgnore
    public String form(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (!StringUtils.isEmpty((CharSequence)city.getId())) {
            BaseEntity cityEntity = this.cityBiz.getEntity(Integer.parseInt(city.getId()));
            model.addAttribute("cityEntity", (Object)cityEntity);
        }
        return "/basic/city/form";
    }

    @ApiOperation(value="\u67e5\u8be2\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="provinceId", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="provinceName", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityId", value="\u5e02\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="cityName", value="\u5e02\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityPy", value="\u57ce\u5e02\u62fc\u97f3\u9996\u5b57\u6bcd", required=false, paramType="query"), @ApiImplicitParam(name="countyId", value="\u53bf\uff0f\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="countyName", value="\u53bf\uff0f\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="townId", value="\u8857\u9053\uff0f\u9547\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="townName", value="\u8857\u9053\uff0f\u9547\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="villageId", value="\u6751\u59d4\u4f1aid", required=false, paramType="query"), @ApiImplicitParam(name="villageName", value="\u6751\u59d4\u4f1a\u540d\u79f0", required=false, paramType="query")})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET, RequestMethod.POST})
    @RequiresPermissions(value={"city:view"})
    @ResponseBody
    public ResultData list(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        BasicUtil.startPage();
        List<Object> cityList = new ArrayList();
        cityList = city.getProvinceId() == null ? this.cityBiz.queryProvinceAndName(city) : this.cityBiz.queryById(city);
        return ResultData.build().success((Object)new EUListBean(cityList, (int)BasicUtil.endPage(cityList).getTotal()));
    }

    @ApiOperation(value="\u83b7\u53d6\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e")
    @ApiImplicitParam(name="id", value="\u4e3b\u952e\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"city:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)city.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("id")}));
        }
        CityEntity _city = (CityEntity)this.cityBiz.getEntity(Integer.parseInt(city.getId()));
        return ResultData.build().success((Object)_city);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u5b9e\u4f53")
    @ApiImplicitParams(value={@ApiImplicitParam(name="provinceId", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="provinceName", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityId", value="\u5e02\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="cityName", value="\u5e02\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityPy", value="\u57ce\u5e02\u62fc\u97f3\u9996\u5b57\u6bcd", required=false, paramType="query"), @ApiImplicitParam(name="countyId", value="\u53bf\uff0f\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="countyName", value="\u53bf\uff0f\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="townId", value="\u8857\u9053\uff0f\u9547\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="townName", value="\u8857\u9053\uff0f\u9547\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="villageId", value="\u6751\u59d4\u4f1aid", required=false, paramType="query"), @ApiImplicitParam(name="villageName", value="\u6751\u59d4\u4f1a\u540d\u79f0", required=false, paramType="query")})
    @RequiresPermissions(value={"city:save"})
    @PostMapping(value={"/save"})
    @ResponseBody
    public ResultData save(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        Snowflake snowflake = IdUtil.createSnowflake((long)0L, (long)0L);
        CityEntity cityEntity = this.cityBiz.queryByEntity(city);
        if (cityEntity != null) {
            return ResultData.build().error("\u5730\u533a\u5df2\u5b58\u5728");
        }
        CityEntity queryEntity = new CityEntity();
        BeanUtils.copyProperties((Object)((Object)city), (Object)((Object)queryEntity));
        queryEntity.setProvinceName(null);
        queryEntity.setCityName(null);
        queryEntity.setCountyName(null);
        queryEntity.setTownName(null);
        queryEntity.setVillageName(null);
        cityEntity = this.cityBiz.queryByEntity(queryEntity);
        if (city.getProvinceId() != null) {
            city.setProvinceName(cityEntity.getProvinceName());
            city.setCityId(snowflake.nextId());
        } else if (city.getCityId() != null) {
            city.setProvinceId(cityEntity.getProvinceId());
            city.setProvinceName(cityEntity.getProvinceName());
            city.setCityName(cityEntity.getCityName());
            city.setCountyId(snowflake.nextId());
        } else if (city.getCountyId() != null) {
            city.setProvinceId(cityEntity.getProvinceId());
            city.setProvinceName(cityEntity.getProvinceName());
            city.setCityId(cityEntity.getCityId());
            city.setCityName(cityEntity.getCityName());
            city.setCountyId(cityEntity.getCountyId());
            city.setCountyName(cityEntity.getCountyName());
            city.setTownId(snowflake.nextId());
        } else if (city.getTownId() != null) {
            city.setProvinceId(cityEntity.getProvinceId());
            city.setProvinceName(cityEntity.getProvinceName());
            city.setCityId(cityEntity.getCityId());
            city.setCityName(cityEntity.getCityName());
            city.setCountyId(cityEntity.getCountyId());
            city.setCountyName(cityEntity.getCountyName());
            city.setTownId(cityEntity.getTownId());
            city.setTownName(cityEntity.getTownName());
            city.setVillageId(snowflake.nextId());
        } else if (city.getProvinceId() == null) {
            city.setProvinceId(snowflake.nextId());
        }
        this.cityBiz.saveEntity(city);
        return ResultData.build().success((Object)city);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e")
    @RequiresPermissions(value={"city:del"})
    @PostMapping(value={"/delete"})
    @ResponseBody
    public ResultData delete(@RequestBody List<CityEntity> citys, HttpServletResponse response, HttpServletRequest request) {
        for (CityEntity city : citys) {
            this.cityBiz.deleteEntity(city);
        }
        this.cityBiz.updateCache();
        return ResultData.build().success();
    }

    @ApiOperation(value="\u66f4\u65b0\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e\u4fe1\u606f\u7701\u5e02\u53bf\u9547\u6751\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952e\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="provinceId", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="provinceName", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityId", value="\u5e02\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="cityName", value="\u5e02\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cityPy", value="\u57ce\u5e02\u62fc\u97f3\u9996\u5b57\u6bcd", required=false, paramType="query"), @ApiImplicitParam(name="countyId", value="\u53bf\uff0f\u533a\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="countyName", value="\u53bf\uff0f\u533a\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="townId", value="\u8857\u9053\uff0f\u9547\u7ea7id", required=false, paramType="query"), @ApiImplicitParam(name="townName", value="\u8857\u9053\uff0f\u9547\u7ea7\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="villageId", value="\u6751\u59d4\u4f1aid", required=false, paramType="query"), @ApiImplicitParam(name="villageName", value="\u6751\u59d4\u4f1a\u540d\u79f0", required=false, paramType="query")})
    @RequiresPermissions(value={"city:update"})
    @PostMapping(value={"/update"})
    @ResponseBody
    public ResultData update(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        this.cityBiz.updateEntity(city);
        return ResultData.build().success((Object)city);
    }

    @ApiOperation(value="\u67e5\u8be2\u7701\u5217\u8868")
    @GetMapping(value={"/province"})
    @ResponseBody
    public ResultData province(HttpServletResponse response, HttpServletRequest request) {
        List<CityEntity> cityList = this.cityBiz.queryProvince();
        return ResultData.build().success(cityList);
    }

    @ApiOperation(value="\u6839\u636e\u7701id\u67e5\u8be2\u57ce\u5e02\u5217\u8868")
    @ApiImplicitParam(name="provinceId", value="\u7701\uff0f\u76f4\u8f96\u5e02\uff0f\u81ea\u6cbb\u533a\u7ea7id", required=true, paramType="query")
    @GetMapping(value={"/city"})
    @ResponseBody
    public ResultData city(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        List<CityEntity> cityList = this.cityBiz.queryCity(city);
        return ResultData.build().success(cityList);
    }

    @ApiOperation(value="\u6839\u636e\u57ce\u5e02id\u67e5\u8be2\u533a\u57df\u5217\u8868")
    @ApiImplicitParam(name="cityId", value="\u5e02\u7ea7id", required=true, paramType="query")
    @GetMapping(value={"/county"})
    @ResponseBody
    public ResultData county(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        List<CityEntity> cityList = this.cityBiz.queryCounty(city);
        return ResultData.build().success(cityList);
    }

    @ApiOperation(value="\u6839\u636e\u533a\u53bfid\u67e5\u8be2\u57ce\u9547\u5217\u8868")
    @ApiImplicitParam(name="countyId", value="\u533a\u53bfId", required=true, paramType="query")
    @GetMapping(value={"/town"})
    @ResponseBody
    public ResultData town(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        BasicUtil.startPage();
        List<CityEntity> cityList = this.cityBiz.queryCounty(city);
        return ResultData.build().success(cityList);
    }

    @ApiOperation(value="\u6839\u636e\u57ce\u9547id\u67e5\u8be2\u8857\u9053\u5217\u8868")
    @ApiImplicitParam(name="townId", value="\u57ce\u9547Id", required=true, paramType="query")
    @GetMapping(value={"/village"})
    @ResponseBody
    public ResultData village(@ModelAttribute @ApiIgnore CityEntity city, HttpServletResponse response, HttpServletRequest request) {
        List<CityEntity> cityList = this.cityBiz.queryCounty(city);
        return ResultData.build().success(cityList);
    }

    @ApiOperation(value="\u751f\u6210json\u6587\u4ef6")
    @PostMapping(value={"/createJson"})
    @ResponseBody
    @RequiresPermissions(value={"city:createJson"})
    public ResultData creatJson(HttpServletResponse response, HttpServletRequest request) {
        int level = 5;
        String type = "tree";
        List<CityBean> cityList = this.cityBiz.queryForTree(level, type);
        byte[] bytes = JSONObject.toJSONBytes((Object)ResultData.build().success(cityList), (SerializerFeature[])new SerializerFeature[0]);
        File file = FileUtil.file((String)BasicUtil.getRealPath(null), (String)"/static/json/city.json");
        FileUtil.writeBytes((byte[])bytes, (File)file);
        return ResultData.build().success();
    }
}

