/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.aop;

import cn.hutool.core.util.ObjectUtil;
import java.lang.reflect.Field;
import java.util.Date;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class SaveOrUpdateAop
extends BaseAop {
    @Pointcut(value="execution(* net.mingsoft..*Action.save(..))")
    public void save() {
    }

    @Pointcut(value="execution(* net.mingsoft..*Action.update(..))")
    public void update() {
    }

    @Before(value="save()")
    public void save(JoinPoint jp) {
        this.setField(jp, "createDate", new Date());
        this.setField(jp, "updateDate", new Date());
        ManagerEntity manager = BasicUtil.getManager();
        if (manager != null) {
            this.setField(jp, "createBy", manager.getId());
        }
    }

    @Before(value="update()")
    public void update(JoinPoint jp) {
        this.setField(jp, "updateDate", new Date());
        ManagerEntity manager = BasicUtil.getManager();
        if (manager != null) {
            this.setField(jp, "updateBy", manager.getId());
        }
    }

    private void setField(JoinPoint jp, String name, Object obj) {
        try {
            Field[] allFields;
            Object[] objs = jp.getArgs();
            if (objs.length == 0 || ObjectUtil.isNull((Object)objs[0])) {
                return;
            }
            for (Field field : allFields = BasicUtil.getAllFields(objs[0])) {
                if (!name.equals(field.getName())) continue;
                field.setAccessible(true);
                field.set(objs[0], obj);
            }
        }
        catch (Exception e) {
            this.LOG.error("Aop\u9519\u8bef\uff1a", (Throwable)e);
        }
    }
}

