/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.realm;

import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;

public abstract class BaseAuthRealm
extends AuthorizingRealm {
    public BaseAuthRealm() {
        this.setAuthenticationTokenClass(UsernamePasswordToken.class);
        this.setCredentialsMatcher((CredentialsMatcher)new SimpleCredentialsMatcher());
    }

    public void clearCachedAuthorizationInfo(String principal) {
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)principal, this.getName());
        this.clearCachedAuthorizationInfo((PrincipalCollection)principals);
    }

    public void clearAllCachedAuthorizationInfo() {
        Cache cache = this.getAuthorizationCache();
        if (cache != null) {
            for (Object key : cache.keys()) {
                cache.remove(key);
            }
        }
    }
}

