/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.util;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.mutable.MutablePair;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.constant.e.BaseCookieEnum;
import net.mingsoft.base.constant.e.BaseEnum;
import net.mingsoft.base.constant.e.BaseSessionEnum;
import net.mingsoft.basic.biz.IAppBiz;
import net.mingsoft.basic.entity.AppEntity;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.MapCacheUtil;
import net.mingsoft.basic.util.SpringUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.config.MSProperties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class BasicUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(BasicUtil.class);
    private static String[] mobileGateWayHeaders = new String[]{"ZXWAP", "chinamobile.com", "monternet.com", "infoX", "XMS 724Solutions HTG", "wap.lizongbo.com", "Bytemobile"};
    private static String[] pcHeaders = new String[]{"Windows 98", "Windows ME", "Windows 2000", "Windows XP", "Windows NT", "Ubuntu"};
    private static String[] mobileUserAgents = new String[]{"Nokia", "SAMSUNG", "MIDP-2", "CLDC1.1", "SymbianOS", "MAUI", "UNTRUSTED/1.0", "Windows CE", "iPhone", "iPad", "Android", "BlackBerry", "UCWEB", "ucweb", "BREW", "J2ME", "YULONG", "YuLong", "COOLPAD", "TIANYU", "TY-", "K-Touch", "Haier", "DOPOD", "Lenovo", "LENOVO", "HUAQIN", "AIGO-", "CTC/1.0", "CTC/2.0", "CMCC", "DAXIAN", "MOT-", "SonyEricsson", "GIONEE", "HTC", "ZTE", "HUAWEI", "webOS", "GoBrowser", "IEMobile", "WAP2.0"};
    @Deprecated
    private static final String PAGE_NO = "pageNo";
    private static final String PAGE_NUMBER = "pageNumber";
    private static final String PAGE_SIZE = "pageSize";
    private static final String PAGE = "page";
    private static final String IDS = "ids";

    public static AppEntity getApp() {
        AppEntity app = BasicUtil.getWebsiteApp();
        if (app == null) {
            AppEntity _app = null;
            IAppBiz appBiz = SpringUtil.getBean(IAppBiz.class);
            if (SpringUtil.getRequest() != null) {
                if (MapCacheUtil.get(BasicUtil.getDomain()) != null) {
                    _app = (AppEntity)((Object)MapCacheUtil.get(BasicUtil.getDomain()));
                } else {
                    _app = (AppEntity)((Object)appBiz.getOne((Wrapper)Wrappers.lambdaQuery().like(AppEntity::getAppUrl, (Object)BasicUtil.getDomain()), false));
                    if (_app == null) {
                        MapCacheUtil.put(BasicUtil.getDomain(), (Object)new AppEntity());
                    } else {
                        MapCacheUtil.put(BasicUtil.getDomain(), (Object)_app);
                    }
                }
            }
            if (_app == null || StringUtils.isBlank((CharSequence)_app.getId())) {
                if (MapCacheUtil.get("firstApp") != null) {
                    _app = (AppEntity)((Object)MapCacheUtil.get("firstApp"));
                } else {
                    _app = appBiz.getFirstApp();
                    MapCacheUtil.put("firstApp", (Object)_app);
                }
            }
            if (_app != null) {
                if (SpringUtil.getRequest() != null) {
                    _app.setAppUrl(BasicUtil.getUrl());
                }
                return _app;
            }
        }
        return app;
    }

    public static AppEntity getWebsiteApp() {
        return (AppEntity)((Object)BasicUtil.getSession("app"));
    }

    public static String getContextPath() {
        Environment environment = SpringUtil.getBean(Environment.class);
        return (String)environment.getProperty("server.servlet.context-path", String.class, (Object)"/");
    }

    public static String getUrl(String server) {
        HttpServletRequest request = SpringUtil.getRequest();
        if (BasicUtil.getWebsiteApp() != null) {
            LOG.debug("BasicUtil.getWebsiteApp() != null is true");
            return BasicUtil.getWebsiteApp().getAppUrl();
        }
        Environment environment = SpringUtil.getBean(Environment.class);
        String scheme = (String)environment.getProperty("ms.scheme", String.class, (Object)"http");
        int port = (Integer)environment.getProperty("server.port", Integer.class, (Object)8080);
        String path = (String)environment.getProperty("server.servlet.context-path", String.class, (Object)"/");
        if (request == null) {
            return null;
        }
        String serverName = request.getServerName();
        if (!StringUtil.isIP(serverName).booleanValue()) {
            server = serverName;
        }
        String basePath = scheme + "://" + Optional.ofNullable(server).orElse(request.getServerName());
        int _port = request.getServerPort();
        if (_port == 80 || _port != port) {
            port = _port;
        }
        if (port == 80 || port == 443) {
            basePath = !"/".equals(path) ? basePath + path + "/" : basePath + "/";
        } else {
            basePath = basePath + ":" + port;
            basePath = !"/".equals(path) ? basePath + path + "/" : basePath + "/";
        }
        LOG.debug("server:{},basePath:{}", (Object)server, (Object)basePath);
        return basePath;
    }

    public static String getUrl() {
        return BasicUtil.getUrl(null);
    }

    public String getMACAddress(String ip) {
        String str = "";
        String macAddress = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            for (int i = 1; i < 100; ++i) {
                str = input.readLine();
                if (str == null || str.indexOf("MAC Address") <= 1) continue;
                macAddress = str.substring(str.indexOf("MAC Address") + 14, str.length());
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        return macAddress;
    }

    public static String getIp() {
        HttpServletRequest request = SpringUtil.getRequest();
        String ipAddress = null;
        LOG.debug("headers:{}", (Object)JSONUtil.toJsonStr((Object)request.getHeaderNames()));
        ipAddress = request.getHeader("X-Forwarded-For");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && (ipAddress = request.getRemoteAddr()).equals("127.0.0.1")) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ipAddress = inet.getHostAddress();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return "0:0:0:0:0:0:0:1".equals(ipAddress) ? "127.0.0.1" : ipAddress;
    }

    public static String getDomain() {
        HttpServletRequest request = SpringUtil.getRequest();
        String path = request.getContextPath();
        String name = request.getServerName();
        StringBuilder serverName = new StringBuilder();
        serverName.append(name);
        if (request.getServerPort() == 80) {
            serverName.append(path);
        } else {
            serverName.append(":").append(request.getServerPort()).append(path);
        }
        String currentDomain = serverName.toString();
        return currentDomain;
    }

    public static void startPage() {
        int pageNo = BasicUtil.getInt(PAGE_NO, 1);
        int pageNumber = BasicUtil.getInt(PAGE_NUMBER, 1);
        int _pageNo = pageNo;
        if (pageNumber > pageNo) {
            _pageNo = pageNumber;
        }
        PageHelper.startPage((int)_pageNo, (int)BasicUtil.getInt(PAGE_SIZE, 10));
    }

    public static int getPageSzie() {
        return BasicUtil.getInt(PAGE_SIZE, 10);
    }

    public static int getPageNo() {
        return BasicUtil.getInt(PAGE_NO, 1);
    }

    public static void startPage(boolean count) {
        BasicUtil.startPage(BasicUtil.getInt(PAGE_NO, 1), BasicUtil.getInt(PAGE_SIZE, 10), count);
    }

    public static void startPage(int pageNo, int pageSize, boolean count) {
        PageHelper.startPage((int)BasicUtil.getInt(PAGE_NO, pageNo), (int)BasicUtil.getInt(PAGE_SIZE, pageSize), (boolean)count);
    }

    public static void orderBy(String orderBy, String order) {
        if (!order.equalsIgnoreCase("DESC") && !order.equalsIgnoreCase("ASC")) {
            order = "DESC";
        }
        PageHelper.orderBy((String)(orderBy + " " + order));
    }

    public static PageInfo endPage(List list, String name) {
        PageInfo page = new PageInfo(list);
        SpringUtil.getRequest().setAttribute("params", (Object)BasicUtil.assemblyRequestUrlParams(new String[]{PAGE_NO}));
        SpringUtil.getRequest().setAttribute(name, (Object)page);
        return page;
    }

    public static PageInfo endPage(List list) {
        return BasicUtil.endPage(list, PAGE);
    }

    public static Boolean getBoolean(String param) {
        String value = SpringUtil.getRequest().getParameter(param);
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Boolean getBoolean(String param, Boolean def) {
        String value = SpringUtil.getRequest().getParameter(param);
        if (StringUtils.isBlank((CharSequence)value)) {
            return def;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Integer getInt(String param, int def) {
        String value = SpringUtil.getRequest().getParameter(param);
        if (NumberUtils.isNumber((String)value)) {
            return Integer.parseInt(value);
        }
        return def;
    }

    public static Integer getInt(String param) {
        return BasicUtil.getInt(param, 0);
    }

    public static String getString(String param, String def) {
        String value = SpringUtil.getRequest().getParameter(param);
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = def;
        }
        return value;
    }

    public static String getString(String param) {
        return BasicUtil.getString(param, "");
    }

    public static int[] getInts(String param) {
        Object[] value = SpringUtil.getRequest().getParameterValues(param);
        if (ArrayUtils.isNotEmpty((Object[])value)) {
            try {
                return StringUtil.stringsToInts((String[])value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static int[] getInts(String param, String split) {
        if (BasicUtil.getInts(param) != null) {
            return BasicUtil.getInts(param);
        }
        String value = SpringUtil.getRequest().getParameter(param);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])value.split(split))) {
            return StringUtil.stringsToInts(value.split(split));
        }
        return null;
    }

    public static int[] getIds() {
        return BasicUtil.getInts(IDS);
    }

    public static Map<String, Object> assemblyRequestMap() {
        HttpServletRequest request = SpringUtil.getRequest();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map map = request.getParameterMap();
        Iterator key = map.keySet().iterator();
        while (key.hasNext()) {
            String k = ((String)key.next()).replace(".", "_");
            String[] value = null;
            if (!StringUtil.isBlank(map.get(k))) {
                try {
                    value = (String[])map.get(k);
                }
                catch (ClassCastException e) {
                    value = new String[]{map.get(k) + ""};
                }
            }
            if (value == null) {
                params.put(k, null);
                request.setAttribute(k, null);
                continue;
            }
            if (value.length == 1) {
                String temp = null;
                if (!StringUtils.isEmpty((CharSequence)value[0])) {
                    temp = value[0];
                }
                params.put(k, temp);
                request.setAttribute(k, (Object)temp);
                continue;
            }
            if (value.length == 0) {
                params.put(k, null);
                request.setAttribute(k, null);
                continue;
            }
            if (value.length <= 1) continue;
            params.put(k, value);
            request.setAttribute(k, (Object)value);
        }
        return params;
    }

    public static String assemblyRequestUrlParams() {
        return BasicUtil.assemblyRequestUrlParams(null);
    }

    public static String assemblyRequestUrlParams(String[] filter) {
        Map map = SpringUtil.getRequest().getParameterMap();
        Iterator key = map.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (key.hasNext()) {
            String k = (String)key.next();
            if (filter != null && Arrays.asList(filter).contains(k) || StringUtil.isBlank(map.get(k))) continue;
            String[] value = null;
            try {
                value = (String[])map.get(k);
            }
            catch (ClassCastException e) {
                value = new String[]{map.get(k) + ""};
            }
            if (value.length == 1) {
                String temp = "";
                if (!StringUtils.isEmpty((CharSequence)value[0])) {
                    temp = value[0];
                }
                sb.append(k).append("=").append(temp).append("&");
                continue;
            }
            if (value.length <= 1) continue;
            sb.append(k).append("=").append(value).append("&");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    public static void removeUrlParams(String[] fitlers) {
        SpringUtil.getRequest().setAttribute("params", (Object)BasicUtil.assemblyRequestUrlParams(fitlers));
    }

    public static Object getSession(BaseSessionEnum key) {
        return SpringUtil.getRequest().getSession().getAttribute(key.toString());
    }

    public static Object getSession(String key) {
        if (SpringUtil.getRequest() == null) {
            return null;
        }
        return SpringUtil.getRequest().getSession().getAttribute(key);
    }

    public static void setSession(BaseSessionEnum key, Object value) {
        SpringUtil.getRequest().getSession().setAttribute(key.toString(), value);
    }

    public static void setSession(String key, Object value) {
        SpringUtil.getRequest().getSession().setAttribute(key, value);
    }

    public static void removeSession(BaseSessionEnum key) {
        SpringUtil.getRequest().getSession().removeAttribute(key.toString());
    }

    public static void removeSession(String key) {
        SpringUtil.getRequest().getSession().removeAttribute(key);
    }

    public static String getRealPath(String filePath) {
        if (filePath != null && (filePath.contains("../") || filePath.contains("..\\"))) {
            throw new BusinessException("\u975e\u6cd5\u8def\u5f84!");
        }
        LOG.debug("filePath {}", (Object)filePath);
        String classPath = BasicUtil.getClassPath(filePath);
        LOG.debug("classPath {}", (Object)classPath);
        if (!classPath.startsWith("file")) {
            ServletContext servlet = SpringUtil.getBean(ServletContext.class);
            LOG.debug("servlet {}", (Object)servlet);
            String path = servlet.getRealPath(File.separator);
            LOG.debug("path {}", (Object)path);
            if (!StringUtils.isEmpty((CharSequence)filePath)) {
                String last = path.charAt(path.length() - 1) + "";
                String frist = filePath.charAt(0) + "";
                path = last.equals(File.separator) ? (frist.equals("\\") || frist.equals("/") ? path + filePath.substring(1) : path + filePath) : (frist.equals("\\") || frist.equals("/") ? path + filePath : path + File.separator + filePath);
            }
            return path;
        }
        String path = System.getProperty("user.dir");
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            path = path + File.separator + filePath;
        }
        return path;
    }

    public static String getRealTemplatePath(String filePath) {
        String path = null;
        String uploadTemplatePath = MSProperties.upload.template;
        if (new File(uploadTemplatePath).isAbsolute()) {
            String os = System.getProperty("os.name");
            String last = uploadTemplatePath.charAt(uploadTemplatePath.length() - 1) + "";
            String frist = filePath.charAt(0) + "";
            if (!"\\".equals(frist) || !"/".equals(frist)) {
                if (!"\\".equals(last) || !"/".equals(last)) {
                    uploadTemplatePath = uploadTemplatePath + "/";
                }
            } else if ("\\".equals(last) || "/".equals(last)) {
                uploadTemplatePath = uploadTemplatePath.substring(0, uploadTemplatePath.length() - 1);
            }
            path = uploadTemplatePath + filePath;
            if (os.toLowerCase().startsWith("win")) {
                return path.replace("/", "\\");
            }
        } else {
            path = BasicUtil.getRealPath(filePath);
        }
        return path;
    }

    public static String getClassPath(String filePath) {
        String os = System.getProperty("os.name");
        String temp = null;
        try {
            temp = ClassUtils.getDefaultClassLoader().getResource("").getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (os.toLowerCase().startsWith("win")) {
            return temp.replace("/", "\\");
        }
        return temp;
    }

    public static Field[] getAllFields(Object object) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    public static void setValue(Object target, String fieldName, Object value) {
        Class<?> clazz = target.getClass();
        String[] fs = fieldName.split("\\.");
        try {
            for (int i = 0; i < fs.length - 1; ++i) {
                Field f = clazz.getDeclaredField(fs[i]);
                f.setAccessible(true);
                Object val = f.get(target);
                if (val == null) {
                    Constructor<?> c = f.getType().getDeclaredConstructor(new Class[0]);
                    c.setAccessible(true);
                    val = c.newInstance(new Object[0]);
                    f.set(target, val);
                }
                target = val;
                clazz = target.getClass();
            }
            Field f = clazz.getDeclaredField(fs[fs.length - 1]);
            f.setAccessible(true);
            f.set(target, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map enumToMap(BaseEnum[] baseEnum) {
        return BasicUtil.enumToMap(baseEnum, true);
    }

    public static Map enumToMap(BaseEnum[] baseEnum, boolean idKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (BaseEnum be : baseEnum) {
            if (idKey) {
                map.put(be.toInt() + "", be.toString());
                continue;
            }
            Enum e = (Enum)be;
            map.put(e.name(), be.toString());
        }
        return map;
    }

    public static Map resToMap(String resPath) {
        return BasicUtil.resToMap(ResourceBundle.getBundle(resPath));
    }

    public static Map resToMap(ResourceBundle rb) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            map.put(key, rb.getString(key));
        }
        return map;
    }

    public static String getCookie(BaseCookieEnum key) {
        HttpServletRequest request = SpringUtil.getRequest();
        if (request.getCookies() != null) {
            for (Cookie c : request.getCookies()) {
                if (!c.getName().equals(key.toString())) continue;
                return c.getValue();
            }
        }
        return null;
    }

    public static String getCookie(String key) {
        HttpServletRequest request = SpringUtil.getRequest();
        if (request.getCookies() != null) {
            for (Cookie c : request.getCookies()) {
                if (!c.getName().equals(key)) continue;
                return c.getValue();
            }
        }
        return null;
    }

    public static void setCookie(HttpServletResponse response, BaseCookieEnum key, Object value) {
        if (value == null) {
            BasicUtil.setCookie(response, null, "/", key.toString(), null, -1);
        } else {
            BasicUtil.setCookie(response, null, "/", key.toString(), value.toString(), -1);
        }
    }

    public static ManagerEntity getManager() {
        Subject subject = SecurityUtils.getSubject();
        if (subject.getPrincipal() instanceof ManagerEntity) {
            return (ManagerEntity)((Object)subject.getPrincipal());
        }
        return null;
    }

    public static void setCookie(HttpServletResponse response, BaseCookieEnum key, Object value, int expiry) {
        BasicUtil.setCookie(response, null, "/", key.toString(), value.toString(), expiry);
    }

    public static void setCookie(HttpServletResponse response, String key, String value, int expiry) {
        BasicUtil.setCookie(response, null, "/", key.toString(), value.toString(), expiry);
    }

    public static void setCookie(HttpServletResponse response, String domain, String key, String value, int expiry) {
        BasicUtil.setCookie(response, domain, "/", key.toString(), value.toString(), expiry);
    }

    public static void setCookie(HttpServletResponse response, String domain, String path, String key, String value, int expiry) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        Cookie cookie = new Cookie(key.toString(), value);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            cookie.setPath(path);
        }
        if (StringUtils.isNotEmpty((CharSequence)domain)) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(expiry);
        response.addCookie(cookie);
    }

    public static boolean isMobileDevice() {
        int i;
        HttpServletRequest request = SpringUtil.getRequest();
        boolean b = false;
        boolean pcFlag = false;
        boolean mobileFlag = false;
        String via = request.getHeader("Via");
        String userAgent = request.getHeader("user-agent");
        for (i = 0; via != null && !via.trim().equals("") && i < mobileGateWayHeaders.length; ++i) {
            if (!via.contains(mobileGateWayHeaders[i])) continue;
            mobileFlag = true;
            break;
        }
        for (i = 0; !mobileFlag && userAgent != null && !userAgent.trim().equals("") && i < mobileUserAgents.length; ++i) {
            if (!userAgent.contains(mobileUserAgents[i])) continue;
            mobileFlag = true;
            break;
        }
        for (i = 0; userAgent != null && !userAgent.trim().equals("") && i < pcHeaders.length; ++i) {
            if (!userAgent.contains(pcHeaders[i])) continue;
            pcFlag = true;
            break;
        }
        if (mobileFlag && !pcFlag) {
            b = true;
        }
        return b;
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return request.getHeader("accept") != null && request.getHeader("accept").equals("*/*") || request.getHeader("X-Requested-With") != null && request.getHeader("X-Requested-With").indexOf("XMLHttpRequest") > -1;
    }

    public static <T> T filter(T obj, String ... filters) {
        if (obj == null) {
            return null;
        }
        final List<String> list = Arrays.asList(filters);
        String str = JSONUtil.parseObj(obj).setDateFormat("yyyy-MM-dd HH:mm:ss").toJSONString(0, (Filter)new Filter<MutablePair<Object, Object>>(){

            public boolean accept(MutablePair<Object, Object> objectObjectMutablePair) {
                return !list.contains(objectObjectMutablePair.getKey());
            }
        });
        return (T)JSONUtil.toBean((String)str, obj.getClass());
    }

    public static void outString(HttpServletResponse response, String dataStr) {
        try {
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = response.getWriter();
            out.print(dataStr);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getMimeType(InputStream fileInput, String fileName) {
        AutoDetectParser parser = new AutoDetectParser();
        parser.setParsers(new HashMap());
        Metadata metadata = new Metadata();
        String fileType = FileNameUtil.extName((String)fileName);
        try {
            parser.parse(fileInput, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        catch (ZeroByteFileException e) {
            return fileType;
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        String contentType = metadata.get("Content-Type");
        if (contentType.contains("/")) {
            fileType = contentType.substring(contentType.lastIndexOf("/") + 1);
        }
        if (fileType.contains("-")) {
            return fileType.substring(fileType.lastIndexOf("-") + 1);
        }
        return fileType;
    }
}

