/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.people.biz.impl;

import com.mingsoft.base.dao.IBaseDao;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.biz.ICategoryBiz;
import com.mingsoft.basic.entity.CategoryEntity;
import com.mingsoft.people.biz.IPeopleBiz;
import com.mingsoft.people.biz.IPeopleStudentBiz;
import com.mingsoft.people.biz.IPeopleUserBiz;
import com.mingsoft.people.biz.impl.PeopleBizImpl;
import com.mingsoft.people.dao.IPeopleStudentDao;
import com.mingsoft.people.entity.PeopleStudentEntity;
import com.mingsoft.util.PageUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="peopleStudentBiz")
public class PeopleStudentBizImpl
extends PeopleBizImpl
implements IPeopleStudentBiz {
    @Autowired
    private IPeopleStudentDao peopleStudentDao;
    @Autowired
    private IPeopleUserBiz peopleUserBiz;
    @Autowired
    private IPeopleBiz peopleBiz;
    @Autowired
    private ICategoryBiz categoryBiz;

    @Override
    protected IBaseDao getDao() {
        return this.peopleStudentDao;
    }

    @Override
    public int savePeopleStudent(PeopleStudentEntity peopleStudentEntity) {
        this.peopleUserBiz.savePeople(peopleStudentEntity);
        return this.peopleStudentDao.saveEntity((BaseEntity)peopleStudentEntity);
    }

    @Override
    public void updatePeopleStudent(PeopleStudentEntity peopleStudentEntity) {
        this.peopleUserBiz.updateEntity((BaseEntity)peopleStudentEntity);
        this.peopleBiz.updatePeople(peopleStudentEntity);
        this.peopleStudentDao.updateEntity((BaseEntity)peopleStudentEntity);
    }

    @Override
    public void deletePeopleStudent(int peopleId) {
        this.deletePeople(peopleId);
        this.peopleStudentDao.deleteEntity(peopleId);
    }

    @Override
    public PeopleStudentEntity getPeopleStudent(int peopleId) {
        return this.peopleStudentDao.getPeopleStudent(peopleId);
    }

    @Override
    public List<PeopleStudentEntity> queryListPageByAppId(Integer appId, PageUtil page) {
        return this.peopleStudentDao.queryPageListByAppId(appId, page);
    }

    @Override
    public Map getStudentInfor(Integer peopleId) {
        PeopleStudentEntity peopleStudent = this.peopleStudentDao.getPeopleStudent(peopleId);
        CategoryEntity city = (CategoryEntity)this.categoryBiz.getEntity(peopleStudent.getPeopleStudentCityID());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (city != null) {
            map.put("city", city.getCategoryTitle());
            CategoryEntity province = (CategoryEntity)this.categoryBiz.getEntity(city.getCategoryCategoryId());
            if (province != null) {
                map.put("province", province.getCategoryTitle());
            }
        }
        map.put("peopleStudent", (Object)peopleStudent);
        return map;
    }

    @Override
    public List<PeopleStudentEntity> queryByMap(Integer appId, PageUtil page, Map where) {
        return this.peopleStudentDao.queryByMap(appId, page, where);
    }

    @Override
    public int getCountByMap(Integer appId, Map where) {
        return this.peopleStudentDao.getCountByMap(appId, where);
    }
}

