/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.db.transaction.manager;

import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StackTracer {
    private static final Logger log = LoggerFactory.getLogger(StackTracer.class);
    private static boolean initialized = false;
    private static Method getStackTraceElement;

    StackTracer() {
    }

    static Optional<StackTraceElement> getStackTraceElement(int n) {
        if (!initialized) {
            StackTracer.initialize();
        }
        return Optional.ofNullable(getStackTraceElement).map(meth -> {
            try {
                return (StackTraceElement)meth.invoke((Object)new Throwable(), n);
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    private static synchronized void initialize() {
        try {
            Method method = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            method.setAccessible(true);
            getStackTraceElement = method;
        }
        catch (NoSuchMethodException e) {
            log.warn("Throwable.getStackTraceElement is not available: " + e.toString());
        }
        finally {
            initialized = true;
        }
    }
}

