/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.db.transaction.manager;

import java.sql.SQLException;
import java.util.List;
import net.moznion.db.transaction.manager.TransactionManager;
import net.moznion.db.transaction.manager.TransactionTraceInfo;

public class TransactionScope
implements AutoCloseable {
    private boolean isActioned = false;
    private final TransactionManager transactionManager;

    public TransactionScope(TransactionManager transactionManager) throws SQLException {
        if (transactionManager == null) {
            throw new IllegalArgumentException("transactionManager must not be null");
        }
        this.transactionManager = transactionManager;
        Boolean originalAutoCommitStatus = transactionManager.getOriginalAutoCommitStatus();
        if (originalAutoCommitStatus == null) {
            originalAutoCommitStatus = transactionManager.getConnection().getAutoCommit();
        }
        transactionManager.txnBegin(originalAutoCommitStatus);
    }

    public void commit() throws SQLException {
        if (this.isActioned) {
            return;
        }
        this.transactionManager.txnCommit();
        this.isActioned = true;
    }

    public void rollback() throws SQLException {
        if (this.isActioned) {
            return;
        }
        this.transactionManager.txnRollback();
        this.isActioned = true;
    }

    public void addEndHook(Runnable r) {
        this.transactionManager.txnAddEndHook(r);
    }

    @Override
    public void close() throws SQLException {
        List<TransactionTraceInfo> activeTransactions = this.transactionManager.getActiveTransactions();
        if (activeTransactions.isEmpty()) {
            return;
        }
        TransactionTraceInfo currentTransactionTraceInfo = activeTransactions.get(activeTransactions.size() - 1);
        if (Thread.currentThread().getId() != currentTransactionTraceInfo.getThreadId()) {
            return;
        }
        if (!this.isActioned) {
            this.rollback();
        }
    }
}

