/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.db.transaction.manager;

public class TransactionTraceInfo {
    static final String UNKNOWN_SYMBOL = "Unknown";
    static final int UNKNOWN_NUM = -1;
    private final String className;
    private final String fileName;
    private final String methodName;
    private final int lineNumber;
    private final long threadId;

    public static Builder builder() {
        return new Builder();
    }

    private TransactionTraceInfo(Builder b) {
        this.className = b.className == null ? UNKNOWN_SYMBOL : b.className;
        this.fileName = b.fileName == null ? UNKNOWN_SYMBOL : b.fileName;
        this.methodName = b.methodName == null ? UNKNOWN_SYMBOL : b.methodName;
        this.lineNumber = b.lineNumber;
        this.threadId = b.threadId;
    }

    public String toString() {
        return "File Name: " + this.fileName + ", Class Name: " + this.className + ", Method Name: " + this.methodName + ", Line Number: " + this.lineNumber + ", Thread ID: " + this.threadId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public static class Builder {
        private String className = "Unknown";
        private String fileName = "Unknown";
        private String methodName = "Unknown";
        private int lineNumber = -1;
        private long threadId = -1L;

        public TransactionTraceInfo build() {
            return new TransactionTraceInfo(this);
        }

        public Builder className(String className) {
            this.className = className;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder threadId(long threadId) {
            this.threadId = threadId;
            return this;
        }
    }
}

