/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.serenitybdd.annotations.Screenshots;
import net.thucydides.model.domain.TakeScreenshots;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepDefinitionAnnotationReader {
    private String stepDefinitionPath;
    private TakeScreenshots screenshotDefaultLevel = TakeScreenshots.UNDEFINED;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepDefinitionAnnotationReader.class);

    public StepDefinitionAnnotationReader(String stepDefinitionPath) {
        this.stepDefinitionPath = stepDefinitionPath;
    }

    public StepDefinitionAnnotationReader(String stepDefinitionPath, TakeScreenshots screenshotDefaultLevel) {
        this.screenshotDefaultLevel = screenshotDefaultLevel;
        this.stepDefinitionPath = stepDefinitionPath;
    }

    public static StepDefinitionAnnotationReader forStepDefinition(String stepDefinitionPath) {
        return new StepDefinitionAnnotationReader(stepDefinitionPath);
    }

    public static Builder withScreenshotLevel(TakeScreenshots screenshotLevel) {
        return new Builder(screenshotLevel);
    }

    public TakeScreenshots getScreenshotPreferences() {
        if (this.stepDefinitionPath == null) {
            return TakeScreenshots.UNDEFINED;
        }
        List<Annotation> stepDefinitionAnnotations = this.annotationsIn(this.className(), this.methodName());
        return stepDefinitionAnnotations.stream().filter(annotation -> annotation instanceof Screenshots).map(annotation -> this.asEnum((Screenshots)annotation)).findFirst().orElse(this.screenshotDefaultLevel);
    }

    private TakeScreenshots asEnum(Screenshots screenshotAnnotation) {
        if (screenshotAnnotation.disabled()) {
            return TakeScreenshots.DISABLED;
        }
        if (screenshotAnnotation.afterEachStep()) {
            return TakeScreenshots.AFTER_EACH_STEP;
        }
        if (screenshotAnnotation.beforeAndAfterEachStep()) {
            return TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP;
        }
        if (screenshotAnnotation.forEachAction()) {
            return TakeScreenshots.FOR_EACH_ACTION;
        }
        if (screenshotAnnotation.onlyOnFailures()) {
            return TakeScreenshots.FOR_FAILURES;
        }
        return TakeScreenshots.UNDEFINED;
    }

    private String className() {
        Matcher matcher = Pattern.compile("^(\\w*\\s)").matcher(this.stepDefinitionPath);
        if (matcher.lookingAt()) {
            this.stepDefinitionPath = matcher.replaceFirst("");
        }
        int lastOpeningParentheses = this.stepDefinitionPath.contains("(") ? this.stepDefinitionPath.lastIndexOf("(") : this.stepDefinitionPath.toCharArray().length;
        String qualifiedMethodName = this.stepDefinitionPath.substring(0, lastOpeningParentheses);
        int endOfClassName = qualifiedMethodName.lastIndexOf(".");
        return this.stepDefinitionPath.substring(0, endOfClassName);
    }

    private String methodName() {
        int lastOpeningParentheses = this.stepDefinitionPath.contains("(") ? this.stepDefinitionPath.lastIndexOf("(") : this.stepDefinitionPath.toCharArray().length;
        String qualifiedMethodName = this.stepDefinitionPath.substring(0, lastOpeningParentheses);
        int startOfMethodName = qualifiedMethodName.lastIndexOf(".") + 1;
        return this.stepDefinitionPath.substring(startOfMethodName, lastOpeningParentheses);
    }

    private List<Annotation> annotationsIn(String className, String methodName) {
        try {
            Optional<Method> matchingMethod = Arrays.stream(Class.forName(className).getMethods()).filter(method -> method.getName().equals(methodName)).findFirst();
            return matchingMethod.map(method -> Arrays.asList(method.getAnnotations())).orElseGet(ArrayList::new);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Could not analyse step definition method " + className + "." + methodName);
            return new ArrayList<Annotation>();
        }
    }

    public static class Builder {
        private final TakeScreenshots screenshotLevel;

        public Builder(TakeScreenshots screenshotLevel) {
            this.screenshotLevel = screenshotLevel;
        }

        public StepDefinitionAnnotationReader forStepDefinition(String stepDefinitionPath) {
            return new StepDefinitionAnnotationReader(stepDefinitionPath, this.screenshotLevel);
        }
    }
}

