/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Properties;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionProvider {
    private final EnvironmentVariables environmentVariables;
    private final Logger logger = LoggerFactory.getLogger(VersionProvider.class);

    public VersionProvider() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public VersionProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public String getVersion() {
        String buildNumber = "UNKNOWN";
        try {
            ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            buildNumber = this.getVersionNameFromCodeSourceURL(codeSource.getLocation());
        }
        catch (Throwable t) {
            this.logger.error("Cannot get version number ", t);
            return this.getVersionLegacyWay();
        }
        return buildNumber;
    }

    String getVersionNameFromCodeSourceURL(URL locationUrl) {
        String buildNumber;
        String archiveName;
        String archiveLoation = locationUrl.toString();
        String string = archiveName = archiveLoation.endsWith(".jar") ? archiveLoation.substring(archiveLoation.lastIndexOf(File.separator) + 1, archiveLoation.length() - ".jar".length()) : "localbuild";
        if (archiveName.endsWith("-SNAPSHOT")) {
            String archiveNameWithoutSnapshotEnding = archiveName.substring(0, archiveName.length() - "-SNAPSHOT".length());
            buildNumber = archiveName.substring(archiveNameWithoutSnapshotEnding.lastIndexOf("-") + 1);
        } else {
            if (archiveName.endsWith("-all")) {
                return this.getVersionLegacyWay();
            }
            buildNumber = archiveName.substring(archiveName.lastIndexOf("-") + 1);
        }
        return buildNumber;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersionLegacyWay() {
        String path = "/serenity-version.properties";
        Properties props = new Properties();
        try (InputStream stream = this.getClass().getResourceAsStream(path);){
            if (stream == null) {
                String string2 = "UNKNOWN";
                return string2;
            }
            props.load(stream);
            stream.close();
            String string = (String)props.get("application.version");
            return string;
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }

    public String getBuildNumberText() {
        return this.environmentVariables.getValue(this.buildNumberVariable(), "UNKNOWN");
    }

    private String buildNumberVariable() {
        return EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalProperty("build.number.variable").orElse("BUILD_NUMBER");
    }
}

