/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.statistics.service;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.ContextIcon;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.requirements.CoreTagProvider;
import net.thucydides.model.statistics.service.TagProvider;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class ContextTagProvider
implements TagProvider,
CoreTagProvider {
    EnvironmentVariables environmentVariables;

    public ContextTagProvider() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public ContextTagProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        if (StringUtils.isEmpty((CharSequence)testOutcome.getContext())) {
            return new HashSet<TestTag>();
        }
        if (!ThucydidesSystemProperty.SERENITY_ADD_CONTEXT_TAG.booleanFrom(this.environmentVariables, true).booleanValue()) {
            return Collections.unmodifiableSet(new HashSet());
        }
        String contextLabelValue = ContextIcon.labelForOutcome(testOutcome);
        List contextLabels = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)contextLabelValue);
        HashSet<TestTag> contextTags = new HashSet<TestTag>();
        contextTags.add(TestTag.withName(String.join((CharSequence)", ", contextLabels)).andType("context"));
        contextTags.addAll(contextLabels.stream().map(contextLabel -> TestTag.withName(contextLabel).andType("context")).collect(Collectors.toSet()));
        return contextTags;
    }
}

