/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.ZipOutput;

public class JarWriter
implements DataEntryWriter {
    private final byte[] header;
    private final int modificationTime;
    private final DataEntryWriter dataEntryWriter;
    private DataEntry currentParentEntry;
    private ZipOutput currentZipOutput;

    public JarWriter(DataEntryWriter dataEntryWriter) {
        this(null, dataEntryWriter);
    }

    public JarWriter(byte[] header, DataEntryWriter dataEntryWriter) {
        this(header, JarWriter.currentTime(), dataEntryWriter);
    }

    public JarWriter(byte[] header, int modificationTime, DataEntryWriter dataEntryWriter) {
        this.header = header;
        this.modificationTime = modificationTime;
        this.dataEntryWriter = dataEntryWriter;
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        this.finishIfNecessary(dataEntry);
        this.setUp(dataEntry);
        if (this.currentZipOutput == null) {
            return false;
        }
        String name = dataEntry.getName() + '/';
        OutputStream outputStream = this.currentZipOutput.createOutputStream(name, false, this.modificationTime);
        outputStream.close();
        return true;
    }

    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return dataEntry1 != null && dataEntry2 != null && dataEntry1.getName().equals(dataEntry2.getName()) && this.dataEntryWriter.sameOutputStream(dataEntry1.getParent(), dataEntry2.getParent());
    }

    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        this.finishIfNecessary(dataEntry);
        this.setUp(dataEntry);
        if (this.currentZipOutput == null) {
            return null;
        }
        return this.currentZipOutput.createOutputStream(dataEntry.getName(), true, this.modificationTime);
    }

    public void close() throws IOException {
        this.finish();
        this.dataEntryWriter.close();
    }

    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "JarWriter");
        this.dataEntryWriter.println(pw, prefix + "  ");
    }

    protected void setUp(DataEntry dataEntry) throws IOException {
        if (this.currentZipOutput == null) {
            this.currentParentEntry = dataEntry.getParent();
            this.currentZipOutput = new ZipOutput(this.dataEntryWriter.createOutputStream(this.currentParentEntry), this.header, null, 1);
        }
    }

    private void finishIfNecessary(DataEntry dataEntry) throws IOException {
        if (this.currentParentEntry != null && !this.dataEntryWriter.sameOutputStream(this.currentParentEntry, dataEntry.getParent())) {
            this.finish();
        }
    }

    protected void finish() throws IOException {
        if (this.currentZipOutput != null) {
            this.currentZipOutput.close();
            this.currentParentEntry = null;
            this.currentZipOutput = null;
        }
    }

    private static int currentTime() {
        Date currentDate = new Date();
        return currentDate.getYear() - 80 << 25 | currentDate.getMonth() + 1 << 21 | currentDate.getDate() << 16 | currentDate.getHours() << 11 | currentDate.getMinutes() << 5 | currentDate.getSeconds() >> 1;
    }
}

