/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.constant.RefConstant;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class LoadingInvocationUnit
extends BasicInvocationUnit {
    private final boolean loadFieldValues;
    private final boolean loadMethodParameterValues;
    private final boolean loadMethodReturnValues;

    public LoadingInvocationUnit(ValueFactory valueFactory) {
        this(valueFactory, true, true, true);
    }

    public LoadingInvocationUnit(ValueFactory valueFactory, boolean loadFieldValues, boolean loadMethodParameterValues, boolean loadMethodReturnValues) {
        super(valueFactory);
        this.loadFieldValues = loadFieldValues;
        this.loadMethodParameterValues = loadMethodParameterValues;
        this.loadMethodReturnValues = loadMethodReturnValues;
    }

    public Value getFieldClassValue(Clazz clazz, RefConstant refConstant, String type) {
        ReferenceValue value;
        Member referencedMember;
        if (this.loadFieldValues && (referencedMember = refConstant.referencedMember) != null && (value = StoringInvocationUnit.getFieldClassValue((Field)referencedMember)) != null) {
            return value;
        }
        return super.getFieldClassValue(clazz, refConstant, type);
    }

    public Value getFieldValue(Clazz clazz, RefConstant refConstant, String type) {
        Value value;
        Member referencedMember;
        if (this.loadFieldValues && (referencedMember = refConstant.referencedMember) != null && (value = StoringInvocationUnit.getFieldValue((Field)referencedMember)) != null) {
            return value;
        }
        return super.getFieldValue(clazz, refConstant, type);
    }

    public Value getMethodParameterValue(Clazz clazz, Method method, int parameterIndex, String type, Clazz referencedClass) {
        Value value;
        if (this.loadMethodParameterValues && (value = StoringInvocationUnit.getMethodParameterValue(method, parameterIndex)) != null) {
            return value;
        }
        return super.getMethodParameterValue(clazz, method, parameterIndex, type, referencedClass);
    }

    public Value getMethodReturnValue(Clazz clazz, RefConstant refConstant, String type) {
        Value value;
        Member referencedMember;
        if (this.loadMethodReturnValues && (referencedMember = refConstant.referencedMember) != null && (value = StoringInvocationUnit.getMethodReturnValue((Method)referencedMember)) != null) {
            return value;
        }
        return super.getMethodReturnValue(clazz, refConstant, type);
    }
}

