/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintWriter;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.ShortestUsageMarker;

public class ShortestUsagePrinter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final ShortestUsageMarker shortestUsageMarker;
    private final boolean verbose;
    private final PrintWriter pw;

    public ShortestUsagePrinter(ShortestUsageMarker shortestUsageMarker, boolean verbose, PrintWriter printWriter) {
        this.shortestUsageMarker = shortestUsageMarker;
        this.verbose = verbose;
        this.pw = printWriter;
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.pw.println(ClassUtil.externalClassName(programClass.getName()));
        this.printReason(programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.pw.println(ClassUtil.externalClassName(libraryClass.getName()));
        this.pw.println("  is a library class.\n");
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String name = programField.getName(programClass);
        String type = programField.getDescriptor(programClass);
        this.pw.println(ClassUtil.externalClassName(programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, name, type) : "." + name));
        this.printReason(programField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String name = programMethod.getName(programClass);
        String type = programMethod.getDescriptor(programClass);
        this.pw.print(ClassUtil.externalClassName(programClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, name, type) : "." + name));
        programMethod.attributesAccept(programClass, this);
        this.pw.println();
        this.printReason(programMethod);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        String name = libraryField.getName(libraryClass);
        String type = libraryField.getDescriptor(libraryClass);
        this.pw.println(ClassUtil.externalClassName(libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullFieldDescription(0, name, type) : "." + name));
        this.pw.println("  is a library field.\n");
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        String name = libraryMethod.getName(libraryClass);
        String type = libraryMethod.getDescriptor(libraryClass);
        this.pw.println(ClassUtil.externalClassName(libraryClass.getName()) + (this.verbose ? ": " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), 0, name, type) : "." + name));
        this.pw.println("  is a library method.\n");
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.pw.print(" (" + lineNumberTableAttribute.getLowestLineNumber() + ":" + lineNumberTableAttribute.getHighestLineNumber() + ")");
    }

    private void printReason(VisitorAccepter visitorAccepter) {
        if (this.shortestUsageMarker.isUsed(visitorAccepter)) {
            ShortestUsageMark shortestUsageMark = this.shortestUsageMarker.getShortestUsageMark(visitorAccepter);
            this.pw.print("  " + shortestUsageMark.getReason());
            shortestUsageMark.acceptClassVisitor(this);
            shortestUsageMark.acceptMemberVisitor(this);
        } else {
            this.pw.println("  is not being kept.\n");
        }
    }
}

