/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class CastToList
extends UnaryExpression {
    private ListType targetType;
    private boolean allowEmpty;

    public CastToList(Expression source, ListType targetType, boolean allowEmpty) {
        super(source);
        this.targetType = targetType;
        this.allowEmpty = allowEmpty;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public ListType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        boolean maybeUntyped;
        this.typeCheckChildren(visitor, contextInfo);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.STRING, this.allowEmpty ? 24576 : 16384);
        RoleDiagnostic role = new RoleDiagnostic(2, "cast as", 0);
        Expression operand = TypeChecker.staticTypeCheck(this.getBaseExpression(), atomicType, false, role, visitor);
        this.setBaseExpression(operand);
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        boolean maybeString = th.relationship(operand.getItemType(), BuiltInAtomicType.STRING) != 4;
        boolean bl = maybeUntyped = th.relationship(operand.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
        if (!maybeString && !maybeUntyped) {
            XPathException err = new XPathException("Casting to list requires an xs:string or xs:untypedAtomic operand");
            err.setErrorCode("XPTY0004");
            err.setLocation(this.getLocation());
            err.setIsTypeError(true);
            throw err;
        }
        if (operand instanceof Literal) {
            GroundedValue literalOperand = ((Literal)operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                try {
                    SequenceIterator seq = this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext());
                    return Literal.makeLiteral(SequenceTool.toGroundedValue(seq));
                }
                catch (XPathException err) {
                    err.maybeSetErrorCode("FORG0001");
                    err.setLocation(this.getLocation());
                    err.setIsTypeError(true);
                    throw err;
                }
            }
            if (literalOperand.getLength() == 0) {
                if (this.allowEmpty) {
                    return operand;
                }
                XPathException err = new XPathException("Cast can never succeed: the operand must not be an empty sequence");
                err.setErrorCode("XPTY0004");
                err.setLocation(this.getLocation());
                err.setIsTypeError(true);
                throw err;
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.optimize(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        if (!Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
            this.allowEmpty = false;
            this.resetLocalStaticProperties();
        }
        return this;
    }

    public int computeCardinality() {
        return 57344;
    }

    public ItemType getItemType() {
        try {
            if (this.targetType.getItemType() instanceof ItemType) {
                return (ItemType)((Object)this.targetType.getItemType());
            }
        }
        catch (MissingComponentException missingComponentException) {
            // empty catch block
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy(RebindingMap rebindings) {
        CastToList c = new CastToList(this.getBaseExpression().copy(rebindings), this.targetType, this.allowEmpty);
        ExpressionTool.copyLocationInfo(this, c);
        c.setRetainedStaticContext(this.getRetainedStaticContext());
        return c;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.getBaseExpression().evaluateItem(context);
        if (value == null) {
            if (this.allowEmpty) {
                return EmptyIterator.emptyIterator();
            }
            XPathException e = new XPathException("Cast does not allow an empty sequence");
            e.setXPathContext(context);
            e.setLocation(this.getLocation());
            e.setErrorCode("XPTY0004");
            throw e;
        }
        return CastToList.cast(value.getStringValueCS(), this.targetType, this.getRetainedStaticContext(), context.getConfiguration().getConversionRules()).iterate();
    }

    public static AtomicSequence cast(CharSequence value, ListType targetType, NamespaceResolver nsResolver, ConversionRules rules) throws XPathException {
        ValidationFailure failure = targetType.validateContent(value, nsResolver, rules);
        if (failure != null) {
            throw failure.makeException();
        }
        return targetType.getTypedValue(value, nsResolver, rules);
    }

    public boolean equals(Object other) {
        return super.equals(other) && other instanceof CastToList && this.targetType == ((CastToList)other).targetType && this.allowEmpty == ((CastToList)other).allowEmpty && ExpressionTool.equalOrNull(this.getRetainedStaticContext(), ((CastToList)other).getRetainedStaticContext());
    }

    public int hashCode() {
        return super.hashCode() ^ this.targetType.hashCode();
    }

    public String toString() {
        return this.targetType.getEQName() + "(" + this.getBaseExpression().toString() + ")";
    }

    public String toShortString() {
        return this.targetType.getDisplayName() + "(" + this.getBaseExpression().toShortString() + ")";
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("castToList", this);
        out.emitAttribute("as", this.targetType.toString());
        this.getBaseExpression().export(out);
        out.endElement();
    }
}

