/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class MapCreate
extends ExtensionFunctionDefinition {
    public static final StructuredQName FUNCTION_NAME = new StructuredQName("map", "http://www.w3.org/2005/xpath-functions/map", "create");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 57344)};

    public StructuredQName getFunctionQName() {
        return FUNCTION_NAME;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return HashTrieMap.SINGLE_MAP_TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new MapCreateCall();
    }

    private class MapCreateCall
    extends ExtensionFunctionCall {
        private MapCreateCall() {
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem next;
            SequenceIterator iter = arguments[0].iterate();
            MapItem baseMap = (MapItem)iter.next();
            if (baseMap == null) {
                return new HashTrieMap(context);
            }
            if (!(baseMap instanceof HashTrieMap)) {
                baseMap = HashTrieMap.copy(baseMap, context);
            }
            while ((next = (MapItem)iter.next()) != null) {
                for (KeyValuePair pair : next) {
                    if (baseMap.get(pair.key) != null) {
                        throw new XPathException("Duplicate key value (" + pair.key + ") in map", "XQDY0137");
                    }
                    baseMap = ((HashTrieMap)baseMap).addEntry(pair.key, pair.value);
                }
            }
            return baseMap;
        }
    }
}

