/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.RuleBasedCollator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class StartsWith
extends CollatingFunctionFixed {
    public static boolean startsWith(StringValue arg0, StringValue arg1, StringCollator collator) throws XPathException {
        if (arg1 == null || arg1.isZeroLength()) {
            return true;
        }
        if (arg0 == null || arg0.isZeroLength()) {
            return false;
        }
        String s0 = arg0.getStringValue();
        String s1 = arg1.getStringValue();
        if (collator instanceof CodepointCollator) {
            return s0.startsWith(s1, 0);
        }
        if (collator instanceof SimpleCollation && ((SimpleCollation)collator).getComparator() instanceof RuleBasedCollator) {
            collator = new RuleBasedSubstringMatcher(collator.getCollationURI(), (RuleBasedCollator)((SimpleCollation)collator).getComparator());
        }
        if (collator instanceof SubstringMatcher) {
            return ((SubstringMatcher)collator).startsWith(s0, s1);
        }
        throw new XPathException("The collation requested for starts-with() does not support substring matching", "FOCH0004");
    }

    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue s0 = (StringValue)arguments[0].head();
        StringValue s1 = (StringValue)arguments[1].head();
        return BooleanValue.get(StartsWith.startsWith(s0, s1, this.getStringCollator()));
    }
}

