/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.InsertBefore;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class MapMerge
extends ExtensionFunctionDefinition {
    public static final StructuredQName FUNCTION_NAME = new StructuredQName("map", "http://www.w3.org/2005/xpath-functions/map", "merge");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 57344), SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 16384)};

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public StructuredQName getFunctionQName() {
        return FUNCTION_NAME;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return HashTrieMap.SINGLE_MAP_TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new MapMergeCall();
    }

    private class MapMergeCall
    extends ExtensionFunctionCall {
        boolean selfContained = false;

        private MapMergeCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.selfContained = !ExpressionTool.refersToVariableOrFunction(arguments[0]);
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((MapMergeCall)destination).selfContained = this.selfContained;
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem next;
            SequenceIterator iter;
            MapItem baseMap;
            MapItem options;
            Sequence dupValue;
            String duplicates = "use-first";
            if (arguments.length > 1 && (dupValue = (options = (MapItem)arguments[1].head()).get(new StringValue("duplicates"))) != null) {
                duplicates = dupValue.head().getStringValue();
            }
            if ((baseMap = (MapItem)(iter = arguments[0].iterate()).next()) == null) {
                return new HashTrieMap(context);
            }
            if (!(baseMap instanceof HashTrieMap)) {
                baseMap = HashTrieMap.copy(baseMap, context);
            }
            while ((next = (MapItem)iter.next()) != null) {
                for (KeyValuePair pair : next) {
                    Sequence existing = baseMap.get(pair.key);
                    if (existing != null) {
                        if (duplicates.equals("use-first") || duplicates.equals("unspecified")) continue;
                        if (duplicates.equals("use-last")) {
                            baseMap = ((HashTrieMap)baseMap).addEntry(pair.key, pair.value);
                            continue;
                        }
                        if (duplicates.equals("combine")) {
                            InsertBefore.InsertIterator combinedIter = new InsertBefore.InsertIterator(pair.value.iterate(), existing.iterate(), 1);
                            GroundedValue combinedValue = SequenceExtent.makeSequenceExtent(combinedIter);
                            baseMap = ((HashTrieMap)baseMap).addEntry(pair.key, combinedValue);
                            continue;
                        }
                        throw new XPathException("Duplicate key in constructed map: " + Err.wrap(pair.key.getStringValueCS()), "FOJS0003");
                    }
                    baseMap = ((HashTrieMap)baseMap).addEntry(pair.key, pair.value);
                }
            }
            return baseMap;
        }
    }
}

