/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.URIResolver;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathSelector
implements Iterable<XdmItem> {
    private XPathExpression exp;
    private XPathDynamicContext dynamicContext;
    private Map<StructuredQName, XPathVariable> declaredVariables;

    protected XPathSelector(XPathExpression exp, Map<StructuredQName, XPathVariable> declaredVariables) {
        this.exp = exp;
        this.declaredVariables = declaredVariables;
        this.dynamicContext = exp.createDynamicContext();
    }

    public void setContextItem(XdmItem item) throws SaxonApiException {
        if (item == null) {
            throw new NullPointerException("contextItem");
        }
        if (!this.exp.getInternalExpression().getPackageData().isSchemaAware()) {
            try {
                Item it = item.getUnderlyingValue().head();
                if (it instanceof NodeInfo && ((NodeInfo)it).getTreeInfo().isTyped()) {
                    throw new SaxonApiException("The supplied node has been schema-validated, but the XPath expression was compiled without schema-awareness");
                }
            }
            catch (XPathException it) {
                // empty catch block
            }
        }
        try {
            this.dynamicContext.setContextItem((Item)item.getUnderlyingValue());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmItem getContextItem() {
        return XdmItem.wrapItem(this.dynamicContext.getContextItem());
    }

    public void setVariable(QName name, XdmValue value) throws SaxonApiException {
        StructuredQName qn = name.getStructuredQName();
        XPathVariable var = this.declaredVariables.get(qn);
        if (var == null) {
            throw new SaxonApiException(new XPathException("Variable has not been declared: " + name));
        }
        try {
            this.dynamicContext.setVariable(var, value.getUnderlyingValue());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public void setURIResolver(URIResolver resolver) {
        this.dynamicContext.setURIResolver(resolver);
    }

    public URIResolver getURIResolver() {
        return this.dynamicContext.getURIResolver();
    }

    public XdmValue evaluate() throws SaxonApiException {
        GroundedValue value;
        try {
            value = SequenceExtent.makeSequenceExtent(this.exp.iterate(this.dynamicContext));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        return XdmValue.wrap(value);
    }

    public XdmItem evaluateSingle() throws SaxonApiException {
        try {
            Item i = this.exp.evaluateSingle(this.dynamicContext);
            if (i == null) {
                return null;
            }
            return (XdmItem)XdmValue.wrap(i);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    @Override
    public Iterator<XdmItem> iterator() throws SaxonApiUncheckedException {
        try {
            return new XdmSequenceIterator(this.exp.iterate(this.dynamicContext));
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public boolean effectiveBooleanValue() throws SaxonApiException {
        try {
            return this.exp.effectiveBooleanValue(this.dynamicContext);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XPathDynamicContext getUnderlyingXPathContext() {
        return this.dynamicContext;
    }
}

