/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.TupleItemType;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class MapType
extends AnyFunctionType {
    public static final MapType ANY_MAP_TYPE = new MapType(BuiltInAtomicType.ANY_ATOMIC, SequenceType.ANY_SEQUENCE);
    public static final MapType EMPTY_MAP_TYPE = new MapType(BuiltInAtomicType.ANY_ATOMIC, SequenceType.ANY_SEQUENCE, true);
    public static final SequenceType OPTIONAL_MAP_ITEM = SequenceType.makeSequenceType(ANY_MAP_TYPE, 24576);
    private AtomicType keyType;
    private SequenceType valueType;
    private boolean mustBeEmpty;

    public MapType(AtomicType keyType, SequenceType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.mustBeEmpty = false;
    }

    public MapType(AtomicType keyType, SequenceType valueType, boolean mustBeEmpty) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.mustBeEmpty = mustBeEmpty;
    }

    public AtomicType getKeyType() {
        return this.keyType;
    }

    public SequenceType getValueType() {
        return this.valueType;
    }

    public boolean isMapType() {
        return true;
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean matches(Item item, TypeHierarchy th) {
        if (!(item instanceof MapItem)) {
            return false;
        }
        if (((MapItem)item).isEmpty()) {
            return true;
        }
        if (this.mustBeEmpty) {
            return false;
        }
        if (this == ANY_MAP_TYPE) {
            return true;
        }
        return ((MapItem)item).conforms(this.keyType, this.valueType, th);
    }

    public int getArity() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 16384)};
    }

    public SequenceType getResultType() {
        if (Cardinality.allowsZero(this.valueType.getCardinality())) {
            return this.valueType;
        }
        return SequenceType.makeSequenceType(this.valueType.getPrimaryType(), Cardinality.union(this.valueType.getCardinality(), 8192));
    }

    public String toString() {
        if (this == ANY_MAP_TYPE) {
            return "map(*)";
        }
        if (this == EMPTY_MAP_TYPE) {
            return "map(\u00b0)";
        }
        FastStringBuffer sb = new FastStringBuffer(100);
        sb.append("map(");
        sb.append(this.keyType.toString());
        sb.append(", ");
        sb.append(this.valueType.toString());
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MapType) {
            MapType f2 = (MapType)other;
            return this.keyType.equals(f2.keyType) && this.valueType.equals(f2.valueType) && this.mustBeEmpty == f2.mustBeEmpty;
        }
        return false;
    }

    public int hashCode() {
        return this.keyType.hashCode() ^ this.valueType.hashCode();
    }

    public int relationship(FunctionItemType other, TypeHierarchy th) {
        if (other == AnyFunctionType.getInstance()) {
            return 2;
        }
        if (this.equals(other)) {
            return 0;
        }
        if (other == ANY_MAP_TYPE) {
            return 2;
        }
        if (other.isArrayType()) {
            return 4;
        }
        if (other instanceof TupleItemType) {
            return TypeHierarchy.inverseRelationship(other.relationship(this, th));
        }
        if (other instanceof MapType) {
            MapType f2 = (MapType)other;
            int keyRel = th.relationship(this.keyType, f2.keyType);
            if (keyRel == 4) {
                return 4;
            }
            int valueRel = th.sequenceTypeRelationship(this.valueType, f2.valueType);
            if (keyRel == 4 || valueRel == 4) {
                return 4;
            }
            if (keyRel == valueRel) {
                return keyRel;
            }
            if (keyRel == 0 && valueRel == 0) {
                return 0;
            }
            if (!(keyRel != 0 && keyRel != 1 || valueRel != 0 && valueRel != 1)) {
                return 1;
            }
            if (!(keyRel != 0 && keyRel != 2 || valueRel != 0 && valueRel != 2)) {
                return 2;
            }
            return 3;
        }
        int rel = 4;
        return rel;
    }

    public Expression makeFunctionSequenceCoercer(Expression exp, RoleDiagnostic role) throws XPathException {
        Expression result = exp;
        return result;
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        this.keyType.visitNamedSchemaComponents(visitor);
        this.valueType.getPrimaryType().visitNamedSchemaComponents(visitor);
    }

    public String generateJavaScriptItemTypeTest(ItemType knownToBe) throws XPathException {
        if (this == ANY_MAP_TYPE) {
            return "return SaxonJS.U.isMap(item)";
        }
        FastStringBuffer fsb = new FastStringBuffer(256);
        fsb.append("function k(item) {" + this.keyType.generateJavaScriptItemTypeTest(BuiltInAtomicType.ANY_ATOMIC) + "};");
        fsb.append("function v(item) {" + this.valueType.getPrimaryType().generateJavaScriptItemTypeTest(AnyItemType.getInstance()) + "};");
        int card = this.valueType.getCardinality();
        fsb.append(Cardinality.generateJavaScriptChecker(card));
        fsb.append("return SaxonJS.U.isMap(item) && item.conforms(k, v, c);");
        return fsb.toString();
    }
}

