/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.value.StringValue;

public class XdmAtomicValue
extends XdmItem {
    protected XdmAtomicValue(AtomicValue value) {
        super(value);
    }

    public XdmAtomicValue(boolean value) {
        super(BooleanValue.get(value));
    }

    public XdmAtomicValue(long value) {
        super(Int64Value.makeDerived(value, BuiltInAtomicType.LONG));
    }

    public XdmAtomicValue(int value) {
        super(Int64Value.makeDerived(value, BuiltInAtomicType.INT));
    }

    public XdmAtomicValue(short value) {
        super(Int64Value.makeDerived(value, BuiltInAtomicType.SHORT));
    }

    public XdmAtomicValue(byte value) {
        super(Int64Value.makeDerived(value, BuiltInAtomicType.BYTE));
    }

    public XdmAtomicValue(BigDecimal value) {
        super(new BigDecimalValue(value));
    }

    public XdmAtomicValue(double value) {
        super(new DoubleValue(value));
    }

    public XdmAtomicValue(float value) {
        super(new FloatValue(value));
    }

    public XdmAtomicValue(String value) {
        super(new StringValue(value));
    }

    public XdmAtomicValue(URI value) {
        super(new AnyURIValue(value.toString()));
    }

    public XdmAtomicValue(QName value) {
        super(new QNameValue(value.getStructuredQName(), BuiltInAtomicType.QNAME));
    }

    public XdmAtomicValue(String lexicalForm, ItemType type) throws SaxonApiException {
        net.sf.saxon.type.ItemType it = type.getUnderlyingItemType();
        if (!it.isPlainType()) {
            throw new SaxonApiException("Requested type is not atomic");
        }
        if (((AtomicType)it).isAbstract()) {
            throw new SaxonApiException("Requested type is an abstract type");
        }
        if (((AtomicType)it).isNamespaceSensitive()) {
            throw new SaxonApiException("Requested type is namespace-sensitive");
        }
        try {
            StringConverter converter = ((AtomicType)it).getStringConverter(type.getConversionRules());
            this.setValue(converter.convertString(lexicalForm).asAtomic());
        }
        catch (ValidationException e) {
            throw new SaxonApiException(e);
        }
    }

    public static XdmAtomicValue makeAtomicValue(Object value) {
        if (value instanceof AtomicValue) {
            return new XdmAtomicValue((AtomicValue)value);
        }
        if (value instanceof Boolean) {
            return new XdmAtomicValue((Boolean)value);
        }
        if (value instanceof Integer) {
            return new XdmAtomicValue((Integer)value);
        }
        if (value instanceof Long) {
            return new XdmAtomicValue((Long)value);
        }
        if (value instanceof Short) {
            return new XdmAtomicValue((Short)value);
        }
        if (value instanceof Character) {
            return new XdmAtomicValue(((Character)value).charValue());
        }
        if (value instanceof Byte) {
            return new XdmAtomicValue((Byte)value);
        }
        if (value instanceof String) {
            return new XdmAtomicValue((String)value);
        }
        if (value instanceof Double) {
            return new XdmAtomicValue((Double)value);
        }
        if (value instanceof Float) {
            return new XdmAtomicValue(((Float)value).floatValue());
        }
        if (value instanceof BigDecimal) {
            return new XdmAtomicValue((BigDecimal)value);
        }
        if (value instanceof BigInteger) {
            return new XdmAtomicValue(IntegerValue.makeIntegerValue((BigInteger)value));
        }
        if (value instanceof URI) {
            return new XdmAtomicValue((URI)value);
        }
        if (value instanceof QName) {
            return new XdmAtomicValue((QName)value);
        }
        throw new IllegalArgumentException(value.toString());
    }

    public AtomicValue getUnderlyingValue() {
        return (AtomicValue)super.getUnderlyingValue();
    }

    public String toString() {
        return this.getStringValue();
    }

    public QName getPrimitiveTypeName() {
        AtomicValue value = this.getUnderlyingValue();
        BuiltInAtomicType type = value.getPrimitiveType();
        return new QName(type.getStructuredQName());
    }

    public QName getTypeName() {
        AtomicValue value = this.getUnderlyingValue();
        AtomicType type = value.getItemType();
        return new QName(type.getStructuredQName());
    }

    public Object getValue() {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof StringValue) {
            return av.getStringValue();
        }
        if (av instanceof IntegerValue) {
            return ((IntegerValue)av).asBigInteger();
        }
        if (av instanceof DoubleValue) {
            return ((DoubleValue)av).getDoubleValue();
        }
        if (av instanceof FloatValue) {
            return Float.valueOf(((FloatValue)av).getFloatValue());
        }
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue();
        }
        if (av instanceof BigDecimalValue) {
            return ((BigDecimalValue)av).getDecimalValue();
        }
        if (av instanceof QNameValue) {
            QNameValue q = (QNameValue)av;
            return new QName(q.getPrefix(), q.getNamespaceURI(), q.getLocalName());
        }
        return av.getStringValue();
    }

    public boolean getBooleanValue() throws SaxonApiException {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue();
        }
        if (av instanceof NumericValue) {
            return !av.isNaN() && ((NumericValue)av).signum() != 0;
        }
        if (av instanceof StringValue) {
            String s = av.getStringValue().trim();
            return "1".equals(s) || "true".equals(s);
        }
        throw new SaxonApiException("Cannot cast item to a boolean");
    }

    public long getLongValue() throws SaxonApiException {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue() ? 0L : 1L;
        }
        if (av instanceof NumericValue) {
            try {
                return ((NumericValue)av).longValue();
            }
            catch (XPathException e) {
                throw new SaxonApiException("Cannot cast item to an integer");
            }
        }
        if (av instanceof StringValue) {
            StringToDouble converter = StringToDouble.getInstance();
            return (long)converter.stringToNumber(av.getStringValueCS());
        }
        throw new SaxonApiException("Cannot cast item to an integer");
    }

    public double getDoubleValue() throws SaxonApiException {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue() ? 0.0 : 1.0;
        }
        if (av instanceof NumericValue) {
            return ((NumericValue)av).getDoubleValue();
        }
        if (av instanceof StringValue) {
            try {
                StringToDouble11 converter = StringToDouble11.getInstance();
                return converter.stringToNumber(av.getStringValueCS());
            }
            catch (NumberFormatException e) {
                throw new SaxonApiException(e.getMessage());
            }
        }
        throw new SaxonApiException("Cannot cast item to a double");
    }

    public BigDecimal getDecimalValue() throws SaxonApiException {
        AtomicValue av = this.getUnderlyingValue();
        if (av instanceof BooleanValue) {
            return ((BooleanValue)av).getBooleanValue() ? BigDecimal.ZERO : BigDecimal.ONE;
        }
        if (av instanceof NumericValue) {
            try {
                return ((NumericValue)av).getDecimalValue();
            }
            catch (XPathException e) {
                throw new SaxonApiException("Cannot cast item to a decimal");
            }
        }
        if (av instanceof StringValue) {
            return new BigDecimal(av.getStringValueCS().toString());
        }
        throw new SaxonApiException("Cannot cast item to a decimal");
    }

    public boolean equals(Object other) {
        if (other instanceof XdmAtomicValue) {
            AtomicMatchKey a = this.getUnderlyingValue().asMapKey();
            AtomicMatchKey b = ((XdmAtomicValue)other).getUnderlyingValue().asMapKey();
            return a.equals(b);
        }
        return false;
    }

    public int hashCode() {
        return this.getUnderlyingValue().asMapKey().hashCode();
    }
}

