/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.VirtualTreeInfo;
import net.sf.saxon.type.SchemaType;

public class VirtualCopy
implements NodeInfo {
    protected String systemId;
    protected NodeInfo original;
    protected VirtualCopy parent;
    protected NodeInfo root;
    protected VirtualTreeInfo tree;

    protected VirtualCopy(NodeInfo base, NodeInfo root) {
        this.original = base;
        this.systemId = base.getBaseURI();
        this.root = root;
    }

    public static VirtualCopy makeVirtualCopy(NodeInfo original) {
        while (original instanceof VirtualCopy) {
            original = ((VirtualCopy)original).original;
        }
        VirtualCopy vc = new VirtualCopy(original, original);
        Configuration config = original.getConfiguration();
        VirtualTreeInfo doc = new VirtualTreeInfo(config, vc);
        long docNr = config.getDocumentNumberAllocator().allocateDocumentNumber();
        doc.setDocumentNumber(docNr);
        vc.tree = doc;
        return vc;
    }

    protected VirtualCopy wrap(NodeInfo node) {
        VirtualCopy vc = new VirtualCopy(node, this.root);
        vc.tree = this.tree;
        return vc;
    }

    public NodeInfo getOriginalNode() {
        return this.original;
    }

    public VirtualTreeInfo getTreeInfo() {
        return this.tree;
    }

    public int getFingerprint() {
        return this.original.getFingerprint();
    }

    public boolean hasFingerprint() {
        return this.original.hasFingerprint();
    }

    public NodeInfo head() {
        return this;
    }

    public SequenceIterator iterate() {
        return SingletonIterator.makeIterator(this);
    }

    public int getNodeKind() {
        return this.original.getNodeKind();
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return other instanceof VirtualCopy && this.getTreeInfo() == other.getTreeInfo() && this.original.isSameNodeInfo(((VirtualCopy)other).original);
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        return this.original.hashCode() ^ (int)(this.getTreeInfo().getDocumentNumber() & Integer.MAX_VALUE) << 19;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public int getLineNumber() {
        return this.original.getLineNumber();
    }

    public int getColumnNumber() {
        return this.original.getColumnNumber();
    }

    public Location saveLocation() {
        return this;
    }

    public int compareOrder(NodeInfo other) {
        return this.original.compareOrder(((VirtualCopy)other).original);
    }

    public int comparePosition(NodeInfo other) {
        return this.original.comparePosition(((VirtualCopy)other).original);
    }

    public String getStringValue() {
        return this.getStringValueCS().toString();
    }

    public CharSequence getStringValueCS() {
        return this.original.getStringValueCS();
    }

    public String getLocalPart() {
        return this.original.getLocalPart();
    }

    public String getURI() {
        return this.original.getURI();
    }

    public String getPrefix() {
        return this.original.getPrefix();
    }

    public String getDisplayName() {
        return this.original.getDisplayName();
    }

    public Configuration getConfiguration() {
        return this.original.getConfiguration();
    }

    public SchemaType getSchemaType() {
        return this.original.getSchemaType();
    }

    public NodeInfo getParent() {
        if (this.original.isSameNodeInfo(this.root)) {
            return null;
        }
        if (this.parent == null) {
            NodeInfo basep = this.original.getParent();
            if (basep == null) {
                return null;
            }
            this.parent = this.wrap(basep);
        }
        return this.parent;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        VirtualCopy newParent = null;
        if (axisNumber == 3 || axisNumber == 2 || axisNumber == 8) {
            newParent = this;
        } else if (axisNumber == 12 || axisNumber == 11 || axisNumber == 7) {
            newParent = this.parent;
        }
        return this.makeCopier(this.original.iterateAxis(axisNumber, nodeTest), newParent, !AxisInfo.isSubtreeAxis[axisNumber]);
    }

    public String getAttributeValue(String uri, String local) {
        return this.original.getAttributeValue(uri, local);
    }

    public NodeInfo getRoot() {
        NodeInfo n = this;
        NodeInfo p;
        while ((p = n.getParent()) != null) {
            n = p;
        }
        return n;
    }

    public boolean hasChildNodes() {
        return this.original.hasChildNodes();
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append("d");
        buffer.append(Long.toString(this.getTreeInfo().getDocumentNumber()));
        this.original.generateId(buffer);
    }

    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        this.original.copy(out, copyOptions, locationId);
    }

    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        ArrayList<NamespaceBinding> allNamespaces = new ArrayList<NamespaceBinding>(20);
        Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(this.original);
        while (iter.hasNext()) {
            allNamespaces.add(iter.next());
        }
        return allNamespaces.toArray(new NamespaceBinding[allNamespaces.size()]);
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public AtomicSequence atomize() throws XPathException {
        return this.original.atomize();
    }

    public boolean isId() {
        return this.original.isId();
    }

    public boolean isIdref() {
        return this.original.isIdref();
    }

    public boolean isNilled() {
        return this.original.isNilled();
    }

    public boolean isStreamed() {
        return false;
    }

    public String getPublicId() {
        return this.original instanceof SourceLocator ? this.original.getPublicId() : null;
    }

    protected boolean isIncludedInCopy(NodeInfo sourceNode) {
        return Navigator.isAncestorOrSelf(this.root, sourceNode);
    }

    protected VirtualCopier makeCopier(AxisIterator axis, VirtualCopy newParent, boolean testInclusion) {
        return new VirtualCopier(axis, newParent, testInclusion);
    }

    protected class VirtualCopier
    implements AxisIterator {
        protected AxisIterator base;
        private VirtualCopy parent;
        protected boolean testInclusion;

        public VirtualCopier(AxisIterator base, VirtualCopy parent, boolean testInclusion) {
            this.base = base;
            this.parent = parent;
            this.testInclusion = testInclusion;
        }

        public NodeInfo next() {
            NodeInfo next = this.base.next();
            if (next != null) {
                if (this.testInclusion && !VirtualCopy.this.isIncludedInCopy(next)) {
                    return null;
                }
                VirtualCopy vc = VirtualCopy.this.wrap(next);
                vc.parent = this.parent;
                vc.systemId = VirtualCopy.this.systemId;
                next = vc;
            }
            return next;
        }

        public void close() {
            this.base.close();
        }

        public int getProperties() {
            return 0;
        }
    }
}

