/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.security.KeyPair;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.snowflake.ingest.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWSHeader;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.RSASSASigner;
import net.snowflake.ingest.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.ingest.internal.com.nimbusds.jwt.SignedJWT;
import net.snowflake.ingest.utils.Cryptor;
import net.snowflake.ingest.utils.ThreadFactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SecurityManager
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityManager.class);
    private static final float LIFETIME = 59.0f;
    private static final int RENEWAL_INTERVAL = 54;
    private transient KeyPair keyPair;
    private String account;
    private String publicKeyFingerPrint;
    private String user;
    private AtomicReference<String> token;
    private AtomicBoolean regenFailed;
    final ThreadFactory tf = ThreadFactoryUtil.poolThreadFactory(this.getClass().getSimpleName(), true);
    private final ScheduledExecutorService keyRenewer = Executors.newScheduledThreadPool(1, this.tf);

    SecurityManager(String accountname, String username, KeyPair keyPair, int timeTillRenewal, TimeUnit unit) {
        if (accountname == null || username == null || keyPair == null) {
            throw new IllegalArgumentException();
        }
        this.account = accountname.toUpperCase();
        this.user = username.toUpperCase();
        this.token = new AtomicReference();
        this.regenFailed = new AtomicBoolean();
        this.keyPair = keyPair;
        this.regenerateToken();
        this.keyRenewer.scheduleAtFixedRate(this::regenerateToken, timeTillRenewal, timeTillRenewal, unit);
    }

    SecurityManager(String accountname, String username, KeyPair keyPair) {
        this(accountname, username, keyPair, 54, TimeUnit.MINUTES);
    }

    private void regenerateToken() {
        String newToken;
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        String subject = String.format("%s.%s", this.account, this.user);
        LOGGER.info("Creating Token with subject {}", (Object)subject);
        String publicKeyFPInJwt = this.calculatePublicKeyFp(this.keyPair);
        String issuer = String.format("%s.%s.%s", this.account, this.user, publicKeyFPInJwt);
        LOGGER.info("Creating Token with issuer {}", (Object)issuer);
        Date iat = new Date(System.currentTimeMillis());
        Date exp = new Date(iat.getTime() + 3540000L);
        JWTClaimsSet claimsSet = builder.issuer(issuer).subject(subject).issueTime(iat).expirationTime(exp).build();
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet);
        RSASSASigner signer = new RSASSASigner(this.keyPair.getPrivate());
        try {
            signedJWT.sign(signer);
            newToken = signedJWT.serialize();
        }
        catch (JOSEException e) {
            this.regenFailed.set(true);
            LOGGER.error("Failed to regenerate token! Exception is as follows : {}", (Object)e.getMessage());
            throw new SecurityException();
        }
        LOGGER.info("Created new JWT");
        this.token.set(newToken);
    }

    String getToken() {
        if (this.regenFailed.get()) {
            LOGGER.error("getToken request failed due to token regeneration failure");
            throw new SecurityException();
        }
        return this.token.get();
    }

    private String calculatePublicKeyFp(KeyPair keyPair) {
        byte[] publicKeyRawBytes = keyPair.getPublic().getEncoded();
        this.publicKeyFingerPrint = String.format("SHA256:%s", Cryptor.sha256HashBase64(publicKeyRawBytes));
        return this.publicKeyFingerPrint;
    }

    String getPublicKeyFingerPrint() {
        return this.publicKeyFingerPrint;
    }

    @Override
    public void close() {
        this.keyRenewer.shutdown();
    }
}

