/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jwt;

import java.text.ParseException;
import net.snowflake.ingest.internal.com.nimbusds.jose.JOSEObject;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWSHeader;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWSObject;
import net.snowflake.ingest.internal.com.nimbusds.jose.Payload;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.ingest.internal.com.nimbusds.jwt.JWT;
import net.snowflake.ingest.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.ingest.internal.net.jcip.annotations.ThreadSafe;
import net.snowflake.ingest.internal.net.minidev.json.JSONObject;

@ThreadSafe
public class SignedJWT
extends JWSObject
implements JWT {
    private static final long serialVersionUID = 1L;

    public SignedJWT(JWSHeader header, JWTClaimsSet claimsSet) {
        super(header, new Payload(claimsSet.toJSONObject()));
    }

    public SignedJWT(Base64URL firstPart, Base64URL secondPart, Base64URL thirdPart) throws ParseException {
        super(firstPart, secondPart, thirdPart);
    }

    @Override
    public JWTClaimsSet getJWTClaimsSet() throws ParseException {
        JSONObject json = this.getPayload().toJSONObject();
        if (json == null) {
            throw new ParseException("Payload of JWS object is not a valid JSON object", 0);
        }
        return JWTClaimsSet.parse(json);
    }

    public static SignedJWT parse(String s2) throws ParseException {
        Base64URL[] parts = JOSEObject.split(s2);
        if (parts.length != 3) {
            throw new ParseException("Unexpected number of Base64URL parts, must be three", 0);
        }
        return new SignedJWT(parts[0], parts[1], parts[2]);
    }
}

