/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.http;

import java.net.URI;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceClient;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.Signer;
import net.snowflake.client.jdbc.internal.amazonaws.handlers.RequestHandler2;
import net.snowflake.client.jdbc.internal.amazonaws.retry.internal.AuthErrorRetryStrategy;
import net.snowflake.client.jdbc.internal.amazonaws.util.AWSRequestMetrics;
import net.snowflake.client.jdbc.internal.amazonaws.util.AWSRequestMetricsFullSupport;
import net.snowflake.client.jdbc.internal.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class ExecutionContext {
    private final AWSRequestMetrics awsRequestMetrics;
    private final List<RequestHandler2> requestHandler2s;
    private String contextUserAgent;
    private final AmazonWebServiceClient awsClient;
    private AWSCredentials credentials;
    private AuthErrorRetryStrategy authErrorRetryStrategy;

    public ExecutionContext(boolean isMetricEnabled) {
        this(null, isMetricEnabled, null);
    }

    public ExecutionContext() {
        this(null, false, null);
    }

    public ExecutionContext(List<RequestHandler2> requestHandler2s, boolean isMetricEnabled, AmazonWebServiceClient awsClient) {
        this.requestHandler2s = requestHandler2s;
        this.awsRequestMetrics = isMetricEnabled ? new AWSRequestMetricsFullSupport() : new AWSRequestMetrics();
        this.awsClient = awsClient;
    }

    public String getContextUserAgent() {
        return this.contextUserAgent;
    }

    public void setContextUserAgent(String contextUserAgent) {
        this.contextUserAgent = contextUserAgent;
    }

    public List<RequestHandler2> getRequestHandler2s() {
        return this.requestHandler2s;
    }

    public AWSRequestMetrics getAwsRequestMetrics() {
        return this.awsRequestMetrics;
    }

    protected AmazonWebServiceClient getAwsClient() {
        return this.awsClient;
    }

    public void setSigner(Signer signer) {
    }

    public Signer getSignerByURI(URI uri) {
        return this.awsClient == null ? null : this.awsClient.getSignerByURI(uri);
    }

    public AWSCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(AWSCredentials credentials) {
        this.credentials = credentials;
    }

    public AuthErrorRetryStrategy getAuthErrorRetryStrategy() {
        return this.authErrorRetryStrategy;
    }

    public void setAuthErrorRetryStrategy(AuthErrorRetryStrategy authErrorRetryStrategy) {
        this.authErrorRetryStrategy = authErrorRetryStrategy;
    }
}

