/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type;

import java.util.Collection;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JavaType;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.type.TypeBase;

public class CollectionLikeType
extends TypeBase {
    private static final long serialVersionUID = 4611641304150899138L;
    protected final JavaType _elementType;

    protected CollectionLikeType(Class<?> clazz, JavaType javaType, Object object, Object object2, boolean bl) {
        super(clazz, javaType.hashCode(), object, object2, bl);
        this._elementType = javaType;
    }

    @Override
    protected JavaType _narrow(Class<?> clazz) {
        return new CollectionLikeType(clazz, this._elementType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType narrowContentsBy(Class<?> clazz) {
        if (clazz == this._elementType.getRawClass()) {
            return this;
        }
        return new CollectionLikeType(this._class, this._elementType.narrowBy(clazz), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType widenContentsBy(Class<?> clazz) {
        if (clazz == this._elementType.getRawClass()) {
            return this;
        }
        return new CollectionLikeType(this._class, this._elementType.widenBy(clazz), this._valueHandler, this._typeHandler, this._asStatic);
    }

    public static CollectionLikeType construct(Class<?> clazz, JavaType javaType) {
        return new CollectionLikeType(clazz, javaType, null, null, false);
    }

    @Override
    public CollectionLikeType withTypeHandler(Object object) {
        return new CollectionLikeType(this._class, this._elementType, this._valueHandler, object, this._asStatic);
    }

    @Override
    public CollectionLikeType withContentTypeHandler(Object object) {
        return new CollectionLikeType(this._class, this._elementType.withTypeHandler(object), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public CollectionLikeType withValueHandler(Object object) {
        return new CollectionLikeType(this._class, this._elementType, object, this._typeHandler, this._asStatic);
    }

    @Override
    public CollectionLikeType withContentValueHandler(Object object) {
        return new CollectionLikeType(this._class, this._elementType.withValueHandler(object), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public CollectionLikeType withStaticTyping() {
        if (this._asStatic) {
            return this;
        }
        return new CollectionLikeType(this._class, this._elementType.withStaticTyping(), this._valueHandler, this._typeHandler, true);
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public boolean isCollectionLikeType() {
        return true;
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public int containedTypeCount() {
        return 1;
    }

    @Override
    public JavaType containedType(int n) {
        return n == 0 ? this._elementType : null;
    }

    @Override
    public String containedTypeName(int n) {
        if (n == 0) {
            return "E";
        }
        return null;
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        return CollectionLikeType._classSignature(this._class, stringBuilder, true);
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        CollectionLikeType._classSignature(this._class, stringBuilder, false);
        stringBuilder.append('<');
        this._elementType.getGenericSignature(stringBuilder);
        stringBuilder.append(">;");
        return stringBuilder;
    }

    @Override
    protected String buildCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._class.getName());
        if (this._elementType != null) {
            stringBuilder.append('<');
            stringBuilder.append(this._elementType.toCanonical());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    public boolean isTrueCollectionType() {
        return Collection.class.isAssignableFrom(this._class);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        CollectionLikeType collectionLikeType = (CollectionLikeType)object;
        return this._class == collectionLikeType._class && this._elementType.equals(collectionLikeType._elementType);
    }

    @Override
    public String toString() {
        return "[collection-like type; class " + this._class.getName() + ", contains " + this._elementType + "]";
    }
}

