/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc;

import java.net.URL;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSHeader;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.KeySourceException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWK;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWKMatcher;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWKSelector;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.KeyType;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.KeyUse;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.source.JWKSource;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.AbstractJWKSelectorWithSource;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.JWSKeySelector;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.proc.SecurityContext;

public class JWSAlgorithmFamilyJWSKeySelector<C extends SecurityContext>
extends AbstractJWKSelectorWithSource<C>
implements JWSKeySelector<C> {
    private final Map<JWSAlgorithm, JWSKeySelector<C>> selectors = new HashMap<JWSAlgorithm, JWSKeySelector<C>>();

    public JWSAlgorithmFamilyJWSKeySelector(JWSAlgorithm.Family jwsAlgFamily, JWKSource<C> jwkSource) {
        super(jwkSource);
        if (jwsAlgFamily == null) {
            throw new IllegalArgumentException("JWS algorithm family must not be null");
        }
        for (JWSAlgorithm jwsAlg : jwsAlgFamily) {
            this.selectors.put(jwsAlg, new JWSVerificationKeySelector<C>(jwsAlg, jwkSource));
        }
    }

    @Override
    public List<? extends Key> selectJWSKeys(JWSHeader header, C context) throws KeySourceException {
        JWSKeySelector<C> selector = this.selectors.get(header.getAlgorithm());
        if (selector == null) {
            return Collections.emptyList();
        }
        return selector.selectJWSKeys(header, context);
    }

    public static <C extends SecurityContext> JWSAlgorithmFamilyJWSKeySelector<C> fromJWKSetURL(URL jwkSetURL) throws KeySourceException {
        RemoteJWKSet jwkSource = new RemoteJWKSet(jwkSetURL);
        return JWSAlgorithmFamilyJWSKeySelector.fromJWKSource(jwkSource);
    }

    public static <C extends SecurityContext> JWSAlgorithmFamilyJWSKeySelector<C> fromJWKSource(JWKSource<C> jwkSource) throws KeySourceException {
        JWKMatcher jwkMatcher = new JWKMatcher.Builder().publicOnly(true).keyUses(KeyUse.SIGNATURE, null).keyTypes(KeyType.RSA, KeyType.EC).build();
        List<JWK> jwks = jwkSource.get(new JWKSelector(jwkMatcher), null);
        for (JWK jwk : jwks) {
            if (KeyType.RSA.equals(jwk.getKeyType())) {
                return new JWSAlgorithmFamilyJWSKeySelector<C>(JWSAlgorithm.Family.RSA, jwkSource);
            }
            if (!KeyType.EC.equals(jwk.getKeyType())) continue;
            return new JWSAlgorithmFamilyJWSKeySelector<C>(JWSAlgorithm.Family.EC, jwkSource);
        }
        throw new KeySourceException("Couldn't retrieve JWKs");
    }
}

