/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.operator.bc;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Signer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.signers.Ed25519Signer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.signers.Ed448Signer;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.util.PublicKeyFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.OperatorCreationException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcEdDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    public static final byte[] DEFAULT_CONTEXT = new byte[0];

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        if (algorithmIdentifier.getAlgorithm().equals(EdECObjectIdentifiers.id_Ed448)) {
            return new Ed448Signer(DEFAULT_CONTEXT);
        }
        return new Ed25519Signer();
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

