/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import net.snowflake.client.config.SFClientConfig;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SFClientConfigParser {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFClientConfigParser.class);
    public static final String SF_CLIENT_CONFIG_FILE_NAME = "sf_client_config.json";
    public static final String SF_CLIENT_CONFIG_ENV_NAME = "SF_CLIENT_CONFIG_FILE";

    public static SFClientConfig loadSFClientConfig(String configFilePath) throws IOException {
        String derivedConfigFilePath = null;
        if (configFilePath != null && !configFilePath.isEmpty()) {
            derivedConfigFilePath = configFilePath;
        } else if (System.getenv().containsKey(SF_CLIENT_CONFIG_ENV_NAME)) {
            derivedConfigFilePath = SnowflakeUtil.systemGetEnv(SF_CLIENT_CONFIG_ENV_NAME);
        } else {
            String driverLocation = Paths.get(SFClientConfigParser.getConfigFilePathFromJDBCJarLocation(), SF_CLIENT_CONFIG_FILE_NAME).toString();
            if (Files.exists(Paths.get(driverLocation, new String[0]), new LinkOption[0])) {
                derivedConfigFilePath = driverLocation;
            } else {
                String userHomeFilePath = Paths.get(SnowflakeUtil.systemGetProperty("user.home"), SF_CLIENT_CONFIG_FILE_NAME).toString();
                if (Files.exists(Paths.get(userHomeFilePath, new String[0]), new LinkOption[0])) {
                    derivedConfigFilePath = userHomeFilePath;
                } else {
                    String tmpFilePath = Paths.get(SnowflakeUtil.systemGetProperty("java.io.tmpdir"), SF_CLIENT_CONFIG_FILE_NAME).toString();
                    if (Files.exists(Paths.get(tmpFilePath, new String[0]), new LinkOption[0])) {
                        derivedConfigFilePath = tmpFilePath;
                    }
                }
            }
        }
        if (derivedConfigFilePath != null) {
            try {
                File configFile = new File(derivedConfigFilePath);
                ObjectMapper objectMapper = new ObjectMapper();
                SFClientConfig clientConfig = objectMapper.readValue(configFile, SFClientConfig.class);
                clientConfig.setConfigFilePath(derivedConfigFilePath);
                return clientConfig;
            }
            catch (IOException e) {
                String customErrorMessage = "Error while reading config file at location: " + derivedConfigFilePath;
                throw new IOException(customErrorMessage, e);
            }
        }
        return null;
    }

    public static String getConfigFilePathFromJDBCJarLocation() {
        if (SnowflakeDriver.class.getProtectionDomain() != null && SnowflakeDriver.class.getProtectionDomain().getCodeSource() != null && SnowflakeDriver.class.getProtectionDomain().getCodeSource().getLocation() != null) {
            String jarPath = SnowflakeDriver.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            String updatedPath = jarPath.substring(0, jarPath.lastIndexOf("/"));
            if (SnowflakeUtil.systemGetProperty("os.name") != null && SnowflakeUtil.systemGetProperty("os.name").toLowerCase().startsWith("windows")) {
                if (updatedPath.startsWith("/")) {
                    updatedPath = updatedPath.substring(1);
                }
                updatedPath = updatedPath.replace("/", "\\");
            }
            return updatedPath;
        }
        return "";
    }
}

