/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.ThreadSafe;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.crypto.CipherHelper;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.ByteUtils;

@ThreadSafe
class RSA1_5 {
    public static byte[] encryptCEK(RSAPublicKey pub, SecretKey cek, Provider provider) throws JOSEException {
        try {
            Cipher cipher = CipherHelper.getInstance("RSA/ECB/PKCS1Padding", provider);
            cipher.init(1, pub);
            return cipher.doFinal(cek.getEncoded());
        }
        catch (IllegalBlockSizeException e) {
            throw new JOSEException("RSA block size exception: The RSA key is too short, try a longer one", e);
        }
        catch (Exception e) {
            throw new JOSEException("Couldn't encrypt Content Encryption Key (CEK): " + e.getMessage(), e);
        }
    }

    public static SecretKey decryptCEK(PrivateKey priv, byte[] encryptedCEK, int keyLength, Provider provider) throws JOSEException {
        byte[] secretKeyBytes;
        block3: {
            try {
                Cipher cipher = CipherHelper.getInstance("RSA/ECB/PKCS1Padding", provider);
                cipher.init(2, priv);
                secretKeyBytes = cipher.doFinal(encryptedCEK);
                if (ByteUtils.safeBitLength(secretKeyBytes) == keyLength) break block3;
                return null;
            }
            catch (Exception e) {
                throw new JOSEException("Couldn't decrypt Content Encryption Key (CEK): " + e.getMessage(), e);
            }
        }
        return new SecretKeySpec(secretKeyBytes, "AES");
    }

    private RSA1_5() {
    }
}

