/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SessionUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeClob;
import net.snowflake.client.jdbc.SnowflakeDatabaseMetaData;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakePreparedStatementV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeStatementV1;
import net.snowflake.client.jdbc.internal.snowflake.common.core.ResourceBundleManager;
import net.snowflake.client.jdbc.telemetryV2.TelemetryService;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SnowflakeConnectionV1
implements Connection {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeConnectionV1.class);
    private static final String JDBC_PROTOCOL_PREFIX = "jdbc:snowflake";
    private static final String NATIVE_PROTOCOL = "http";
    private static final String SSL_NATIVE_PROTOCOL = "https";
    private boolean isClosed = true;
    private SQLWarning sqlWarnings = null;
    private String newClientForUpdate;
    private AtomicInteger _injectedDelay = new AtomicInteger(0);
    private String databaseVersion = null;
    private int databaseMajorVersion = 0;
    private int databaseMinorVersion = 0;
    private int loginTimeout = DriverManager.getLoginTimeout() > 0 ? DriverManager.getLoginTimeout() : 60;
    private int networkTimeoutInMilli = 0;
    private static final ResourceBundleManager errorResourceBundleManager = ResourceBundleManager.getSingleton("net.snowflake.client.jdbc.jdbc_error_messages");
    private Properties clientInfo = new Properties();
    private int transactionIsolation = 0;
    private int injectSocketTimeout = 0;
    private int injectClientPause = 0;
    private String injectFileUploadFailure = null;
    private SFSession sfSession;

    public SnowflakeConnectionV1(String url, Properties info) throws SQLException {
        logger.info("Trying to establish session, JDBC driver version: {}", SnowflakeDriver.implementVersion);
        TelemetryService.getInstance().updateContext(url, info);
        this.sfSession = new SFSession();
        try {
            this.initSessionProperties(url, info);
            this.sfSession.open();
            this.databaseVersion = this.sfSession.getDatabaseVersion();
            this.databaseMajorVersion = this.sfSession.getDatabaseMajorVersion();
            this.databaseMinorVersion = this.sfSession.getDatabaseMinorVersion();
            this.newClientForUpdate = this.sfSession.getNewClientForUpdate();
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
        this.appendWarnings(this.sfSession.getSqlWarnings());
        this.isClosed = false;
    }

    static Map<String, Object> mergeProperties(String url, Properties info) {
        String queryParams;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        int queryParamsIndex = url.indexOf("?");
        String serverUrl = queryParamsIndex > 0 ? url.substring(0, queryParamsIndex) : url;
        String string = queryParams = queryParamsIndex > 0 ? url.substring(queryParamsIndex + 1) : null;
        if (queryParams != null && !queryParams.isEmpty()) {
            String[] entries;
            for (String entry : entries = queryParams.split("&")) {
                int sep = entry.indexOf("=");
                if (sep <= 0) continue;
                String key = entry.substring(0, sep).toUpperCase();
                properties.put(key, entry.substring(sep + 1));
            }
        }
        for (Map.Entry entry : info.entrySet()) {
            properties.put(entry.getKey().toString().toUpperCase(), entry.getValue());
        }
        boolean sslOn = SnowflakeConnectionV1.getBooleanTrueByDefault(properties.get("SSL"));
        serverUrl = serverUrl.replace(JDBC_PROTOCOL_PREFIX, sslOn ? SSL_NATIVE_PROTOCOL : NATIVE_PROTOCOL);
        properties.put("SERVERURL", serverUrl);
        properties.remove("SSL");
        if (properties.get("ACCOUNT") == null && serverUrl != null && serverUrl.indexOf(".") > 0 && serverUrl.indexOf("://") > 0) {
            String string2 = serverUrl.substring(serverUrl.indexOf("://") + 3, serverUrl.indexOf("."));
            logger.debug("set account name to {}", string2);
            properties.put("ACCOUNT", string2);
        }
        return properties;
    }

    void initSessionProperties(String url, Properties info) throws SFException {
        Map<String, Object> properties = SnowflakeConnectionV1.mergeProperties(url, info);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.sfSession.addProperty(entry.getKey(), entry.getValue());
        }
        this.sfSession.addProperty(SFSessionProperty.APP_ID, (Object)"JDBC");
        this.sfSession.addProperty(SFSessionProperty.APP_VERSION, (Object)SnowflakeDriver.implementVersion);
        for (Map.Entry<String, Object> entry : SessionUtil.JVM_PARAMS_TO_PARAMS.entrySet()) {
            String value = System.getProperty(entry.getKey());
            if (value == null || this.sfSession.containProperty((String)entry.getValue())) continue;
            this.sfSession.addProperty((String)entry.getValue(), (Object)value);
        }
    }

    private static boolean getBooleanTrueByDefault(Object value) {
        if (value instanceof String) {
            String value0 = (String)value;
            return !"off".equalsIgnoreCase(value0) && !"false".equalsIgnoreCase(value0);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    private void executeImmediate(String stmtText) throws SQLException {
        try (Statement statement = this.createStatement();){
            statement.execute(stmtText);
        }
    }

    public String getNewClientForUpdate() {
        return this.newClientForUpdate;
    }

    @Override
    public Statement createStatement() throws SQLException {
        SnowflakeStatementV1 statement = new SnowflakeStatementV1(this);
        return statement;
    }

    @Override
    public void close() throws SQLException {
        logger.debug(" public void close() throws SQLException");
        if (this.isClosed) {
            return;
        }
        try {
            if (this.sfSession != null) {
                this.sfSession.close();
                this.sfSession = null;
            }
            this.isClosed = true;
        }
        catch (SFException ex) {
            throw new SnowflakeSQLException(ex.getCause(), ex.getSqlState(), ex.getVendorCode(), ex.getParams());
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        logger.debug(" public boolean isClosed() throws SQLException");
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        logger.debug(" public DatabaseMetaData getMetaData() throws SQLException");
        return new SnowflakeDatabaseMetaData(this);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        logger.debug(" public CallableStatement prepareCall(String sql) throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug(" public CallableStatement prepareCall(String sql, int resultSetType,");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug(" public CallableStatement prepareCall(String sql, int resultSetType,");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        logger.debug(" public String nativeSQL(String sql) throws SQLException");
        return sql;
    }

    @Override
    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        logger.debug(" public void setAutoCommit(boolean isAutoCommit) throws SQLException");
        try {
            this.executeImmediate("alter session set autocommit=" + Boolean.toString(isAutoCommit));
        }
        catch (SnowflakeSQLException sse) {
            if (sse.getSQLState().equals("0A000")) {
                logger.debug("Autocommit API is not supported for this connection.");
            }
            throw sse;
        }
    }

    private List<String> queryGSMetaData(String querySQL, List<String> columnNames) throws SQLException {
        Throwable throwable = null;
        try (Statement statement = this.createStatement();){
            Throwable throwable2;
            ResultSet rs;
            block26: {
                ArrayList<String> arrayList;
                block27: {
                    block28: {
                        statement.execute(querySQL);
                        rs = statement.getResultSet();
                        throwable2 = null;
                        if (rs == null || !rs.next()) break block26;
                        ArrayList<String> columnValues = new ArrayList<String>();
                        for (String columnName : columnNames) {
                            columnValues.add(rs.getString(columnName));
                        }
                        arrayList = columnValues;
                        if (rs == null) break block27;
                        if (throwable2 == null) break block28;
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block27;
                    }
                    rs.close();
                }
                return arrayList;
            }
            try {
                try {
                    try {
                        throw new SQLException(errorResourceBundleManager.getLocalizedMessage(ErrorCode.BAD_RESPONSE.getMessageCode().toString()));
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (rs != null) {
                        if (throwable2 != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            rs.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        logger.debug(" public boolean getAutoCommit() throws SQLException");
        return this.sfSession.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        logger.debug(" public void commit() throws SQLException");
        this.executeImmediate("commit");
    }

    @Override
    public void rollback() throws SQLException {
        logger.debug(" public void rollback() throws SQLException");
        this.executeImmediate("rollback");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        logger.debug(" public void rollback(Savepoint savepoint) throws SQLException");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        logger.debug(" public void setReadOnly(boolean readOnly) throws SQLException");
        if (readOnly) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        logger.debug(" public boolean isReadOnly() throws SQLException");
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        logger.debug(" public void setCatalog(String catalog) throws SQLException");
        this.executeImmediate("use database \"" + catalog + "\"");
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.sfSession.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        logger.debug(" public void setTransactionIsolation(int level) throws SQLException. level = {}", level);
        if (level != 0 && level != 2) {
            throw new SQLFeatureNotSupportedException("Transaction Isolation " + Integer.toString(level) + " not supported.", ErrorCode.FEATURE_UNSUPPORTED.getSqlState(), ErrorCode.FEATURE_UNSUPPORTED.getMessageCode());
        }
        this.transactionIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        logger.debug(" public int getTransactionIsolation() throws SQLException");
        return this.transactionIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        logger.debug(" public SQLWarning getWarnings() throws SQLException");
        return this.sqlWarnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        logger.debug(" public void clearWarnings() throws SQLException");
        this.sfSession.clearSqlWarnings();
        this.sqlWarnings = null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug(" public Statement createStatement(int resultSetType, int resultSetConcurrency)");
        logger.debug("resultSetType=" + resultSetType + "; resultSetConcurrency=" + resultSetConcurrency);
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug(" public Statement createStatement(int resultSetType, int resultSetConcurrency,");
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        logger.debug(" public PreparedStatement prepareStatement(String sql) throws SQLException");
        return this.prepareStatement(sql, false);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        logger.debug(" public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        logger.debug(" public PreparedStatement prepareStatement(String sql, int[] columnIndexes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        logger.debug(" public PreparedStatement prepareStatement(String sql, String[] columnNames)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        logger.debug(" public PreparedStatement prepareStatement(String sql, int resultSetType,");
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            logger.error("result set type ({}) or result set concurrency ({}) not supported", resultSetType, resultSetConcurrency);
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        logger.debug(" public PreparedStatement prepareStatement(String sql, int resultSetType,");
        if (resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, boolean skipParsing) throws SQLException {
        logger.debug(" public PreparedStatement prepareStatement(String sql, boolean skipParsing)");
        return new SnowflakePreparedStatementV1(this, sql, skipParsing);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        return new SnowflakeClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        logger.debug(" public void setClientInfo(Properties properties)");
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.clear();
        this.clientInfo.putAll((Map<?, ?>)properties);
        if (this.sfSession != null) {
            this.sfSession.setClientInfo(properties);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        logger.debug(" public void setClientInfo(String name, String value)");
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.setProperty(name, value);
        if (this.sfSession != null) {
            this.sfSession.setClientInfo(name, value);
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        logger.debug(" public Properties getClientInfo() throws SQLException");
        if (this.sfSession != null) {
            return this.sfSession.getClientInfo();
        }
        if (this.clientInfo != null) {
            Properties copy = new Properties();
            copy.putAll((Map<?, ?>)this.clientInfo);
            return copy;
        }
        return null;
    }

    @Override
    public String getClientInfo(String name) {
        if (this.sfSession != null) {
            return this.sfSession.getClientInfo(name);
        }
        logger.debug(" public String getClientInfo(String name)");
        if (this.clientInfo != null) {
            return this.clientInfo.getProperty(name);
        }
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        logger.debug(" public Array createArrayOf(String typeName, Object[] elements)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        logger.debug(" public Struct createStruct(String typeName, Object[] attributes)");
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        logger.debug(" public void setSchema(String schema) throws SQLException");
        String databaseName = this.getCatalog();
        if (databaseName == null) {
            this.executeImmediate("use schema \"" + schema + "\"");
        } else {
            this.executeImmediate("use schema \"" + databaseName + "\".\"" + schema + "\"");
        }
    }

    @Override
    public String getSchema() throws SQLException {
        return this.sfSession.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        logger.debug(" public void abort(Executor executor) throws SQLException");
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        logger.debug(" public void setNetworkTimeout(Executor executor, int milliseconds)");
        this.networkTimeoutInMilli = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        logger.debug(" public int getNetworkTimeout() throws SQLException");
        return this.networkTimeoutInMilli;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        logger.debug(" public boolean isWrapperFor(Class<?> iface) throws SQLException");
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        logger.debug(" public <T> T unwrap(Class<T> iface) throws SQLException");
        if (!iface.isInstance(this)) {
            throw new RuntimeException(this.getClass().getName() + " not unwrappable from " + iface.getName());
        }
        return (T)this;
    }

    public static int getMajorVersion() {
        return SnowflakeDriver.majorVersion;
    }

    public static int getMinorVersion() {
        return SnowflakeDriver.minorVersion;
    }

    public int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    public int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public void uploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName, long streamSize) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, streamSize, false);
    }

    public void compressAndUploadStream(String stageName, String destPrefix, InputStream inputStream, String destFileName) throws SQLException {
        this.uploadStreamInternal(stageName, destPrefix, inputStream, destFileName, 0L, true);
    }

    private void uploadStreamInternal(String stageName, String destPrefix, InputStream inputStream, String destFileName, long streamSize, boolean compressData) throws SQLException {
        logger.debug("upload data from stream: stageName={}, destPrefix={}, destFileName={}", stageName, destPrefix, destFileName);
        if (stageName == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "stage name is null");
        }
        if (destFileName == null) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "stage name is null");
        }
        SnowflakeStatementV1 stmt = new SnowflakeStatementV1(this);
        StringBuilder putCommand = new StringBuilder();
        putCommand.append("put file:///tmp/placeholder ");
        if (!stageName.startsWith("@")) {
            putCommand.append("@");
        }
        putCommand.append(stageName);
        if (destPrefix != null) {
            if (!destPrefix.startsWith("/")) {
                putCommand.append("/");
            }
            putCommand.append(destPrefix);
        }
        SnowflakeFileTransferAgent transferAgent = null;
        transferAgent = new SnowflakeFileTransferAgent(putCommand.toString(), this.sfSession, stmt.getSfStatement());
        transferAgent.setSourceStream(inputStream);
        transferAgent.setDestFileNameForStreamSource(destFileName);
        transferAgent.setSourceStreamSize(streamSize);
        transferAgent.setCompressSourceFromStream(compressData);
        transferAgent.setOverwrite(true);
        transferAgent.execute();
        stmt.close();
    }

    public InputStream downloadStream(String stageName, String sourceFileName, boolean decompress) throws SnowflakeSQLException {
        logger.debug("download data to stream: stageName={}, sourceFileName={}", stageName, sourceFileName);
        if (stageName == null || stageName.isEmpty()) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "stage name is null or empty");
        }
        if (sourceFileName == null || sourceFileName.isEmpty()) {
            throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), "source file name is null or empty");
        }
        SnowflakeStatementV1 stmt = new SnowflakeStatementV1(this);
        StringBuilder getCommand = new StringBuilder();
        getCommand.append("get ");
        if (!stageName.startsWith("@")) {
            getCommand.append("@");
        }
        getCommand.append(stageName);
        getCommand.append("/");
        if (sourceFileName.startsWith("/")) {
            sourceFileName = sourceFileName.substring(1);
        }
        getCommand.append(sourceFileName);
        getCommand.append(" file:///tmp/ /*jdbc download stream*/");
        SnowflakeFileTransferAgent transferAgent = new SnowflakeFileTransferAgent(getCommand.toString(), this.sfSession, stmt.getSfStatement());
        InputStream stream = transferAgent.downloadStream(sourceFileName);
        if (decompress) {
            try {
                return new GZIPInputStream(stream);
            }
            catch (IOException ex) {
                throw new SnowflakeSQLException("XX000", ErrorCode.INTERNAL_ERROR.getMessageCode(), ex.getMessage());
            }
        }
        return stream;
    }

    public void setInjectedDelay(int delay) {
        if (this.sfSession != null) {
            this.sfSession.setInjectedDelay(delay);
        }
        this._injectedDelay.set(delay);
    }

    void injectedDelay() {
        int d = this._injectedDelay.get();
        if (d != 0) {
            this._injectedDelay.set(0);
            try {
                logger.trace("delayed for {}", d);
                Thread.sleep(d);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setInjectFileUploadFailure(String fileToFail) {
        if (this.sfSession != null) {
            this.sfSession.setInjectFileUploadFailure(fileToFail);
        }
        this.injectFileUploadFailure = fileToFail;
    }

    public String getInjectFileUploadFailure() {
        return this.injectFileUploadFailure;
    }

    public SFSession getSfSession() {
        return this.sfSession;
    }

    private void appendWarning(SQLWarning w) {
        if (this.sqlWarnings == null) {
            this.sqlWarnings = w;
        } else {
            this.sqlWarnings.setNextWarning(w);
        }
    }

    private void appendWarnings(List<SFException> warnings) {
        for (SFException e : warnings) {
            this.appendWarning(new SQLWarning(e.getMessage(), e.getSqlState(), e.getVendorCode()));
        }
    }
}

