/*
 * Decompiled with CFR 0.152.
 */
package net.wouterdanes;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wouterdanes.TemplateRunConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="mustache")
public class MustacheMojo
extends AbstractMojo {
    private static final String FILE_PREFIX = "file:";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{([^}]+)}");
    @Parameter(required=true)
    private List<TemplateRunConfiguration> templates;
    @Parameter
    private String context;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Charset charset;
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + Charset.defaultCharset() + ", i.e. build is platform dependent!"));
            charset = Charset.defaultCharset();
        } else {
            charset = Charset.forName(this.encoding);
        }
        Object parsedContext = this.createContext(this.context, charset);
        for (TemplateRunConfiguration configuration : this.templates) {
            this.getLog().info((CharSequence)("Generating '" + configuration.getOutputPath() + "'"));
            this.runTemplateConfiguration(parsedContext, configuration, charset);
        }
    }

    private void runTemplateConfiguration(Object globalContext, TemplateRunConfiguration configuration, Charset charset) throws MojoFailureException, MojoExecutionException {
        Object templateContext = this.createContext(configuration.getContext(), charset);
        if (templateContext == null) {
            if (globalContext == null) {
                throw new MojoFailureException("Template has no defined context and plugin context is also empty");
            }
            templateContext = globalContext;
        }
        Mustache mustache = MustacheMojo.createTemplate(configuration.getTemplateFile(), charset);
        File outputFile = new File(configuration.getOutputPath());
        File parent = outputFile.getParentFile();
        if (!parent.exists() || parent.mkdirs()) {
            throw new MojoFailureException("Output directory cannot be created.");
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), charset);){
            mustache.execute((Writer)writer, templateContext);
        }
        catch (IOException e) {
            throw new MojoFailureException((Object)e, "Cannot open output file", "Cannot open output file: " + e.getMessage());
        }
        catch (MustacheException e) {
            throw new MojoFailureException((Object)e, "Cannot process template", "Cannot process template: " + e.getMessage());
        }
    }

    private Object createContext(String contextConfiguration, Charset charset) throws MojoFailureException {
        if (contextConfiguration == null) {
            return null;
        }
        Yaml yaml = new Yaml();
        String contextSource = MustacheMojo.obtainContextSource(contextConfiguration, charset);
        Matcher matcher = PROPERTY_PATTERN.matcher(contextSource);
        LinkedHashSet<String> props = new LinkedHashSet<String>(10);
        while (matcher.find()) {
            props.add(matcher.group(1));
        }
        for (String prop : props) {
            if (this.project.getProperties().containsKey(prop)) {
                contextSource = contextSource.replace(String.format("${%s}", prop), this.project.getProperties().getProperty(prop));
                continue;
            }
            this.getLog().warn((CharSequence)String.format("Property '%s' referenced in context, but doesn't exist in Maven Project...", prop));
        }
        return yaml.load(contextSource);
    }

    private static String obtainContextSource(String contextConfiguration, Charset charset) throws MojoFailureException {
        if (contextConfiguration.startsWith("---\n")) {
            return contextConfiguration;
        }
        String trimmedContext = contextConfiguration.trim();
        if (trimmedContext.startsWith(FILE_PREFIX)) {
            String filename = trimmedContext.substring(FILE_PREFIX.length());
            try {
                byte[] bytes = Files.readAllBytes(Paths.get(filename, new String[0]));
                return new String(bytes, charset);
            }
            catch (IOException e) {
                throw new MojoFailureException((Object)e, "Cannot load yaml from file", "Cannot load yaml from file");
            }
        }
        throw new MojoFailureException("Cannot load context. Either pass a filename in the form 'file:[filename]' or include a complete yaml document, prefied with '---\\n");
    }

    private static Mustache createTemplate(File template, Charset charset) throws MojoFailureException {
        Mustache mustache;
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(template), charset);){
            mustache = mf.compile((Reader)reader, "template");
        }
        catch (IOException e) {
            throw new MojoFailureException((Object)e, "Cannot open template", "Cannot open template");
        }
        return mustache;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setTemplates(List<TemplateRunConfiguration> templates) {
        this.templates = templates;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

