/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.modules.ojb.CommaListIterator;
import xdoclet.modules.ojb.LogHelper;
import xdoclet.modules.ojb.OjbMemberTagsHandler;
import xdoclet.modules.ojb.constraints.ConstraintException;
import xdoclet.modules.ojb.constraints.JdbcTypeHelper;
import xdoclet.modules.ojb.model.ClassDescriptorDef;
import xdoclet.modules.ojb.model.CollectionDescriptorDef;
import xdoclet.modules.ojb.model.ColumnDef;
import xdoclet.modules.ojb.model.DefBase;
import xdoclet.modules.ojb.model.FieldDescriptorDef;
import xdoclet.modules.ojb.model.ForeignkeyDef;
import xdoclet.modules.ojb.model.IndexDef;
import xdoclet.modules.ojb.model.IndexDescriptorDef;
import xdoclet.modules.ojb.model.ModelDef;
import xdoclet.modules.ojb.model.NestedDef;
import xdoclet.modules.ojb.model.ObjectCacheDef;
import xdoclet.modules.ojb.model.ProcedureArgumentDef;
import xdoclet.modules.ojb.model.ProcedureDef;
import xdoclet.modules.ojb.model.ReferenceDescriptorDef;
import xdoclet.modules.ojb.model.TableDef;
import xdoclet.modules.ojb.model.TorqueModelDef;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.AbstractClass;
import xjavadoc.XClass;

public class OjbTagsHandler
extends XDocletTagSupport {
    private static final String CONFIG_PARAM_CHECKS = "checks";
    private static final String CONFIG_PARAM_VERBOSE = "verbose";
    private static final String CONFIG_PARAM_DATABASENAME = "databaseName";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_CONSTANT = "constant";
    private static final String ATTRIBUTE_DEFAULT = "default";
    private static final String ATTRIBUTE_DEFAULT_RIGHT = "default-right";
    private static final String ATTRIBUTE_LEVEL = "level";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_UNIQUE = "unique";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String LEVEL_CLASS = "class";
    private static final String LEVEL_COLLECTION = "collection";
    private static final String LEVEL_COLUMN = "column";
    private static final String LEVEL_FIELD = "field";
    private static final String LEVEL_FOREIGNKEY = "foreignkey";
    private static final String LEVEL_INDEX = "index";
    private static final String LEVEL_INDEX_DESC = "index-desc";
    private static final String LEVEL_OBJECT_CACHE = "object-cache";
    private static final String LEVEL_PROCEDURE = "procedure";
    private static final String LEVEL_PROCEDURE_ARGUMENT = "procedure-argument";
    private static final String LEVEL_REFERENCE = "reference";
    private static final String LEVEL_TABLE = "table";
    private ModelDef _model = new ModelDef();
    private TorqueModelDef _torqueModel = null;
    private ClassDescriptorDef _curClassDef = null;
    private FieldDescriptorDef _curFieldDef = null;
    private ReferenceDescriptorDef _curReferenceDef = null;
    private CollectionDescriptorDef _curCollectionDef = null;
    private ClassDescriptorDef _curExtent = null;
    private ObjectCacheDef _curObjectCacheDef = null;
    private IndexDescriptorDef _curIndexDescriptorDef = null;
    private ProcedureDef _curProcedureDef = null;
    private ProcedureArgumentDef _curProcedureArgumentDef = null;
    private String _curIndexColumn = null;
    private TableDef _curTableDef = null;
    private ColumnDef _curColumnDef = null;
    private ForeignkeyDef _curForeignkeyDef = null;
    private IndexDef _curIndexDef = null;
    private String _curPairLeft = null;
    private String _curPairRight = null;
    static /* synthetic */ Class class$xdoclet$modules$ojb$OjbTagsHandler;
    static /* synthetic */ Class class$xdoclet$modules$ojb$XDocletModulesOjbMessages;

    public static String getDefaultJdbcTypeForCurrentMember() throws XDocletException {
        if (OjbMemberTagsHandler.getMemberDimension() > 0) {
            return "LONGVARBINARY";
        }
        String type = OjbMemberTagsHandler.getMemberType().getQualifiedName();
        return JdbcTypeHelper.getDefaultJdbcTypeFor(type);
    }

    private static String getDefaultJdbcConversionForCurrentMember() throws XDocletException {
        if (OjbMemberTagsHandler.getMemberDimension() > 0) {
            return "org.apache.ojb.broker.accesslayer.conversions.Object2ByteArrFieldConversion";
        }
        String type = OjbMemberTagsHandler.getMemberType().getQualifiedName();
        return JdbcTypeHelper.getDefaultConversionFor(type);
    }

    public void processClass(String template, Properties attributes) throws XDocletException {
        if (!this._model.hasClass(OjbTagsHandler.getCurrentClass().getQualifiedName())) {
            LogHelper.debug(true, class$xdoclet$modules$ojb$OjbTagsHandler == null ? (class$xdoclet$modules$ojb$OjbTagsHandler = OjbTagsHandler.class$("xdoclet.modules.ojb.OjbTagsHandler")) : class$xdoclet$modules$ojb$OjbTagsHandler, "processClass", "Type " + OjbTagsHandler.getCurrentClass().getQualifiedName());
        }
        ClassDescriptorDef classDef = this.ensureClassDef(OjbTagsHandler.getCurrentClass());
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            classDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        this._curClassDef = classDef;
        this.generate(template);
        this._curClassDef = null;
    }

    public void forAllClassDefinitions(String template, Properties attributes) throws XDocletException {
        Iterator it = this._model.getClasses();
        while (it.hasNext()) {
            this._curClassDef = (ClassDescriptorDef)it.next();
            this.generate(template);
        }
        this._curClassDef = null;
        LogHelper.debug(true, class$xdoclet$modules$ojb$OjbTagsHandler == null ? (class$xdoclet$modules$ojb$OjbTagsHandler = OjbTagsHandler.class$("xdoclet.modules.ojb.OjbTagsHandler")) : class$xdoclet$modules$ojb$OjbTagsHandler, "forAllClassDefinitions", "Processed " + this._model.getNumClasses() + " types");
    }

    public void originalClass(String template, Properties attributes) throws XDocletException {
        OjbTagsHandler.pushCurrentClass((XClass)this._curClassDef.getOriginalClass());
        this.generate(template);
        OjbTagsHandler.popCurrentClass();
    }

    public String prepare() throws XDocletException {
        String checkLevel = (String)OjbTagsHandler.getDocletContext().getConfigParam(CONFIG_PARAM_CHECKS);
        ArrayList queue = new ArrayList();
        Iterator it = this._model.getClasses();
        while (it.hasNext()) {
            ClassDescriptorDef classDef = (ClassDescriptorDef)it.next();
            XClass original = classDef.getOriginalClass();
            boolean isFinished = false;
            queue.clear();
            while (!isFinished) {
                Iterator baseIt;
                if (original == null) {
                    isFinished = true;
                    baseIt = queue.iterator();
                    while (baseIt.hasNext()) {
                        original = (XClass)baseIt.next();
                        ClassDescriptorDef baseDef = this._model.getClass(original.getQualifiedName());
                        baseIt.remove();
                        if (baseDef != null) {
                            classDef.addDirectBaseType(baseDef);
                            continue;
                        }
                        isFinished = false;
                        break;
                    }
                }
                if (isFinished) continue;
                if (original.getInterfaces() != null) {
                    baseIt = original.getInterfaces().iterator();
                    while (baseIt.hasNext()) {
                        queue.add(baseIt.next());
                    }
                }
                if (original.getSuperclass() != null) {
                    queue.add(original.getSuperclass());
                }
                original = null;
            }
        }
        try {
            this._model.process();
            this._model.checkConstraints(checkLevel);
        }
        catch (ConstraintException ex) {
            throw new XDocletException(ex.getMessage());
        }
        return "";
    }

    public void forAllSubClasses(String template, Properties attributes) throws XDocletException {
        ArrayList subTypes = new ArrayList();
        XClass type = OjbTagsHandler.getCurrentClass();
        this.addDirectSubTypes(type, subTypes);
        int pos = 0;
        while (pos < subTypes.size()) {
            type = (XClass)subTypes.get(pos);
            ClassDescriptorDef classDef = this._model.getClass(type.getQualifiedName());
            if (classDef != null && classDef.hasProperty("ojb-persistent")) {
                ++pos;
                continue;
            }
            subTypes.remove(pos);
            this.addDirectSubTypes(type, subTypes);
        }
        Iterator it = subTypes.iterator();
        while (it.hasNext()) {
            OjbTagsHandler.pushCurrentClass((XClass)((XClass)it.next()));
            this.generate(template);
            OjbTagsHandler.popCurrentClass();
        }
    }

    public String addExtent(Properties attributes) throws XDocletException {
        String name = attributes.getProperty(ATTRIBUTE_NAME);
        if (!this._model.hasClass(name)) {
            throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ojb$XDocletModulesOjbMessages == null ? (class$xdoclet$modules$ojb$XDocletModulesOjbMessages = OjbTagsHandler.class$("xdoclet.modules.ojb.XDocletModulesOjbMessages")) : class$xdoclet$modules$ojb$XDocletModulesOjbMessages), (String)"COULD_NOT_FIND_TYPE", (String[])new String[]{name}));
        }
        this._curClassDef.addExtentClass(this._model.getClass(name));
        return "";
    }

    public void forAllExtents(String template, Properties attributes) throws XDocletException {
        Iterator it = this._curClassDef.getExtentClasses();
        while (it.hasNext()) {
            this._curExtent = (ClassDescriptorDef)it.next();
            this.generate(template);
        }
        this._curExtent = null;
    }

    public String extent(Properties attributes) throws XDocletException {
        return this._curExtent.getName();
    }

    public String processIndexDescriptor(Properties attributes) throws XDocletException {
        String name = attributes.getProperty(ATTRIBUTE_NAME);
        IndexDescriptorDef indexDef = this._curClassDef.getIndexDescriptor(name);
        if (indexDef == null) {
            indexDef = new IndexDescriptorDef(name);
            this._curClassDef.addIndexDescriptor(indexDef);
        }
        if (indexDef.getName() == null || indexDef.getName().length() == 0) {
            throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ojb$XDocletModulesOjbMessages == null ? (class$xdoclet$modules$ojb$XDocletModulesOjbMessages = OjbTagsHandler.class$("xdoclet.modules.ojb.XDocletModulesOjbMessages")) : class$xdoclet$modules$ojb$XDocletModulesOjbMessages), (String)"INDEX_NAME_MISSING", (String[])new String[]{this._curClassDef.getName()}));
        }
        attributes.remove(ATTRIBUTE_NAME);
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            indexDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        return "";
    }

    public void forAllIndexDescriptorDefinitions(String template, Properties attributes) throws XDocletException {
        Iterator it = this._curClassDef.getIndexDescriptors();
        while (it.hasNext()) {
            this._curIndexDescriptorDef = (IndexDescriptorDef)it.next();
            this.generate(template);
        }
        this._curIndexDescriptorDef = null;
    }

    public void forAllIndexDescriptorColumns(String template, Properties attributes) throws XDocletException {
        String fields = this._curIndexDescriptorDef.getProperty("fields");
        CommaListIterator it = new CommaListIterator(fields);
        while (it.hasNext()) {
            String name = it.getNext();
            FieldDescriptorDef fieldDef = this._curClassDef.getField(name);
            if (fieldDef == null) {
                throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ojb$XDocletModulesOjbMessages == null ? (class$xdoclet$modules$ojb$XDocletModulesOjbMessages = OjbTagsHandler.class$("xdoclet.modules.ojb.XDocletModulesOjbMessages")) : class$xdoclet$modules$ojb$XDocletModulesOjbMessages), (String)"INDEX_FIELD_MISSING", (String[])new String[]{name, this._curIndexDescriptorDef.getName(), this._curClassDef.getName()}));
            }
            this._curIndexColumn = fieldDef.getProperty(LEVEL_COLUMN);
            this.generate(template);
        }
        this._curIndexColumn = null;
    }

    public String indexColumn(Properties attributes) throws XDocletException {
        return this._curIndexColumn;
    }

    public String processObjectCache(Properties attributes) throws XDocletException {
        ObjectCacheDef objCacheDef = this._curClassDef.setObjectCache(attributes.getProperty("class"));
        attributes.remove("class");
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            objCacheDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        return "";
    }

    public void forObjectCache(String template, Properties attributes) throws XDocletException {
        this._curObjectCacheDef = this._curClassDef.getObjectCache();
        if (this._curObjectCacheDef != null) {
            this.generate(template);
            this._curObjectCacheDef = null;
        }
    }

    public String processProcedure(Properties attributes) throws XDocletException {
        String type = attributes.getProperty(ATTRIBUTE_TYPE);
        ProcedureDef procDef = this._curClassDef.getProcedure(type);
        if (procDef == null) {
            procDef = new ProcedureDef(type);
            this._curClassDef.addProcedure(procDef);
        }
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            procDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        return "";
    }

    public void forAllProcedures(String template, Properties attributes) throws XDocletException {
        Iterator it = this._curClassDef.getProcedures();
        while (it.hasNext()) {
            this._curProcedureDef = (ProcedureDef)it.next();
            this.generate(template);
        }
        this._curProcedureDef = null;
    }

    public String processProcedureArgument(Properties attributes) throws XDocletException {
        String id = attributes.getProperty(ATTRIBUTE_NAME);
        ProcedureArgumentDef argDef = this._curClassDef.getProcedureArgument(id);
        if (argDef == null) {
            argDef = new ProcedureArgumentDef(id);
            this._curClassDef.addProcedureArgument(argDef);
        }
        attributes.remove(ATTRIBUTE_NAME);
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            argDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        return "";
    }

    public void forAllProcedureArguments(String template, Properties attributes) throws XDocletException {
        String argNameList = this._curProcedureDef.getProperty("arguments");
        CommaListIterator it = new CommaListIterator(argNameList);
        while (it.hasNext()) {
            this._curProcedureArgumentDef = this._curClassDef.getProcedureArgument(it.getNext());
            this.generate(template);
        }
        this._curProcedureArgumentDef = null;
    }

    public void processAnonymousField(Properties attributes) throws XDocletException {
        if (!attributes.containsKey(ATTRIBUTE_NAME)) {
            throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ojb$XDocletModulesOjbMessages == null ? (class$xdoclet$modules$ojb$XDocletModulesOjbMessages = OjbTagsHandler.class$("xdoclet.modules.ojb.XDocletModulesOjbMessages")) : class$xdoclet$modules$ojb$XDocletModulesOjbMessages), (String)"PARAMETER_IS_REQUIRED", (String[])new String[]{ATTRIBUTE_NAME}));
        }
        String name = attributes.getProperty(ATTRIBUTE_NAME);
        FieldDescriptorDef fieldDef = this._curClassDef.getField(name);
        if (fieldDef == null) {
            fieldDef = new FieldDescriptorDef(name);
            this._curClassDef.addField(fieldDef);
        }
        fieldDef.setAnonymous();
        LogHelper.debug(false, class$xdoclet$modules$ojb$OjbTagsHandler == null ? (class$xdoclet$modules$ojb$OjbTagsHandler = OjbTagsHandler.class$("xdoclet.modules.ojb.OjbTagsHandler")) : class$xdoclet$modules$ojb$OjbTagsHandler, "processAnonymousField", "  Processing anonymous field " + fieldDef.getName());
        attributes.remove(ATTRIBUTE_NAME);
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            fieldDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        fieldDef.setProperty("access", "anonymous");
    }

    public void processField(String template, Properties attributes) throws XDocletException {
        String name = OjbMemberTagsHandler.getMemberName();
        String defaultType = OjbTagsHandler.getDefaultJdbcTypeForCurrentMember();
        String defaultConversion = OjbTagsHandler.getDefaultJdbcConversionForCurrentMember();
        FieldDescriptorDef fieldDef = this._curClassDef.getField(name);
        if (fieldDef == null) {
            fieldDef = new FieldDescriptorDef(name);
            this._curClassDef.addField(fieldDef);
        }
        LogHelper.debug(false, class$xdoclet$modules$ojb$OjbTagsHandler == null ? (class$xdoclet$modules$ojb$OjbTagsHandler = OjbTagsHandler.class$("xdoclet.modules.ojb.OjbTagsHandler")) : class$xdoclet$modules$ojb$OjbTagsHandler, "processField", "  Processing field " + fieldDef.getName());
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            fieldDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        fieldDef.setProperty("java-type", OjbMemberTagsHandler.getMemberType().getQualifiedName());
        fieldDef.setProperty("default-jdbc-type", defaultType);
        if (defaultConversion != null) {
            fieldDef.setProperty("default-conversion", defaultConversion);
        }
        this._curFieldDef = fieldDef;
        this.generate(template);
        this._curFieldDef = null;
    }

    public void forAllFieldDefinitions(String template, Properties attributes) throws XDocletException {
        Iterator it = this._curClassDef.getFields();
        while (it.hasNext()) {
            this._curFieldDef = (FieldDescriptorDef)it.next();
            if (this.isFeatureIgnored(LEVEL_FIELD) || this._curFieldDef.getBooleanProperty("ignore", false)) continue;
            this.generate(template);
        }
        this._curFieldDef = null;
    }

    public String fieldConstraint(Properties attributes) throws XDocletException {
        return this._curFieldDef.getSizeConstraint();
    }

    public void processAnonymousReference(Properties attributes) throws XDocletException {
        ReferenceDescriptorDef refDef = this._curClassDef.getReference("super");
        if (refDef == null) {
            refDef = new ReferenceDescriptorDef("super");
            this._curClassDef.addReference(refDef);
        }
        refDef.setAnonymous();
        LogHelper.debug(false, class$xdoclet$modules$ojb$OjbTagsHandler == null ? (class$xdoclet$modules$ojb$OjbTagsHandler = OjbTagsHandler.class$("xdoclet.modules.ojb.OjbTagsHandler")) : class$xdoclet$modules$ojb$OjbTagsHandler, "processAnonymousReference", "  Processing anonymous reference");
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            refDef.setProperty(attrName, attributes.getProperty(attrName));
        }
    }

    public void processReference(String template, Properties attributes) throws XDocletException {
        String name = OjbMemberTagsHandler.getMemberName();
        XClass type = OjbMemberTagsHandler.getMemberType();
        int dim = OjbMemberTagsHandler.getMemberDimension();
        ReferenceDescriptorDef refDef = this._curClassDef.getReference(name);
        if (refDef == null) {
            refDef = new ReferenceDescriptorDef(name);
            this._curClassDef.addReference(refDef);
        }
        LogHelper.debug(false, class$xdoclet$modules$ojb$OjbTagsHandler == null ? (class$xdoclet$modules$ojb$OjbTagsHandler = OjbTagsHandler.class$("xdoclet.modules.ojb.OjbTagsHandler")) : class$xdoclet$modules$ojb$OjbTagsHandler, "processReference", "  Processing reference " + refDef.getName());
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            refDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        if (type == null) {
            throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ojb$XDocletModulesOjbMessages == null ? (class$xdoclet$modules$ojb$XDocletModulesOjbMessages = OjbTagsHandler.class$("xdoclet.modules.ojb.XDocletModulesOjbMessages")) : class$xdoclet$modules$ojb$XDocletModulesOjbMessages), (String)"COULD_NOT_DETERMINE_TYPE_OF_MEMBER", (String[])new String[]{name}));
        }
        if (dim > 0) {
            throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ojb$XDocletModulesOjbMessages == null ? (class$xdoclet$modules$ojb$XDocletModulesOjbMessages = OjbTagsHandler.class$("xdoclet.modules.ojb.XDocletModulesOjbMessages")) : class$xdoclet$modules$ojb$XDocletModulesOjbMessages), (String)"MEMBER_CANNOT_BE_A_REFERENCE", (String[])new String[]{name, this._curClassDef.getName()}));
        }
        refDef.setProperty("variable-type", type.getQualifiedName());
        String typeName = this.searchForPersistentSubType(type);
        if (typeName != null) {
            refDef.setProperty("default-class-ref", typeName);
        }
        this._curReferenceDef = refDef;
        this.generate(template);
        this._curReferenceDef = null;
    }

    public void forAllReferenceDefinitions(String template, Properties attributes) throws XDocletException {
        Iterator it = this._curClassDef.getReferences();
        while (it.hasNext()) {
            this._curReferenceDef = (ReferenceDescriptorDef)it.next();
            if (this._curReferenceDef.isAnonymous() && this._curReferenceDef.getOwner() != this._curClassDef || this.isFeatureIgnored(LEVEL_REFERENCE) || this._curReferenceDef.getBooleanProperty("ignore", false)) continue;
            this.generate(template);
        }
        this._curReferenceDef = null;
    }

    public void processCollection(String template, Properties attributes) throws XDocletException {
        String name = OjbMemberTagsHandler.getMemberName();
        CollectionDescriptorDef collDef = this._curClassDef.getCollection(name);
        if (collDef == null) {
            collDef = new CollectionDescriptorDef(name);
            this._curClassDef.addCollection(collDef);
        }
        LogHelper.debug(false, class$xdoclet$modules$ojb$OjbTagsHandler == null ? (class$xdoclet$modules$ojb$OjbTagsHandler = OjbTagsHandler.class$("xdoclet.modules.ojb.OjbTagsHandler")) : class$xdoclet$modules$ojb$OjbTagsHandler, "processCollection", "  Processing collection " + collDef.getName());
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            collDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        if (OjbMemberTagsHandler.getMemberDimension() > 0) {
            collDef.setProperty("array-element-class-ref", OjbMemberTagsHandler.getMemberType().getQualifiedName());
        } else {
            collDef.setProperty("variable-type", OjbMemberTagsHandler.getMemberType().getQualifiedName());
        }
        this._curCollectionDef = collDef;
        this.generate(template);
        this._curCollectionDef = null;
    }

    public void forAllCollectionDefinitions(String template, Properties attributes) throws XDocletException {
        Iterator it = this._curClassDef.getCollections();
        while (it.hasNext()) {
            this._curCollectionDef = (CollectionDescriptorDef)it.next();
            if (this.isFeatureIgnored(LEVEL_COLLECTION) || this._curCollectionDef.getBooleanProperty("ignore", false)) continue;
            this.generate(template);
        }
        this._curCollectionDef = null;
    }

    public String processNested(Properties attributes) throws XDocletException {
        String name = OjbMemberTagsHandler.getMemberName();
        XClass type = OjbMemberTagsHandler.getMemberType();
        int dim = OjbMemberTagsHandler.getMemberDimension();
        NestedDef nestedDef = this._curClassDef.getNested(name);
        if (type == null) {
            throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ojb$XDocletModulesOjbMessages == null ? (class$xdoclet$modules$ojb$XDocletModulesOjbMessages = OjbTagsHandler.class$("xdoclet.modules.ojb.XDocletModulesOjbMessages")) : class$xdoclet$modules$ojb$XDocletModulesOjbMessages), (String)"COULD_NOT_DETERMINE_TYPE_OF_MEMBER", (String[])new String[]{name}));
        }
        if (dim > 0) {
            throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ojb$XDocletModulesOjbMessages == null ? (class$xdoclet$modules$ojb$XDocletModulesOjbMessages = OjbTagsHandler.class$("xdoclet.modules.ojb.XDocletModulesOjbMessages")) : class$xdoclet$modules$ojb$XDocletModulesOjbMessages), (String)"MEMBER_CANNOT_BE_NESTED", (String[])new String[]{name, this._curClassDef.getName()}));
        }
        ClassDescriptorDef nestedTypeDef = this._model.getClass(type.getQualifiedName());
        if (nestedTypeDef == null) {
            throw new XDocletException(Translator.getString((Class)(class$xdoclet$modules$ojb$XDocletModulesOjbMessages == null ? (class$xdoclet$modules$ojb$XDocletModulesOjbMessages = OjbTagsHandler.class$("xdoclet.modules.ojb.XDocletModulesOjbMessages")) : class$xdoclet$modules$ojb$XDocletModulesOjbMessages), (String)"COULD_NOT_DETERMINE_TYPE_OF_MEMBER", (String[])new String[]{name}));
        }
        if (nestedDef == null) {
            nestedDef = new NestedDef(name, nestedTypeDef);
            this._curClassDef.addNested(nestedDef);
        }
        LogHelper.debug(false, class$xdoclet$modules$ojb$OjbTagsHandler == null ? (class$xdoclet$modules$ojb$OjbTagsHandler = OjbTagsHandler.class$("xdoclet.modules.ojb.OjbTagsHandler")) : class$xdoclet$modules$ojb$OjbTagsHandler, "processNested", "  Processing nested object " + nestedDef.getName() + " of type " + nestedTypeDef.getName());
        Enumeration<?> attrNames = attributes.propertyNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            nestedDef.setProperty(attrName, attributes.getProperty(attrName));
        }
        return "";
    }

    public String processModification(Properties attributes) throws XDocletException {
        String name = attributes.getProperty(ATTRIBUTE_NAME);
        Properties mods = this._curClassDef.getModification(name);
        if (mods == null) {
            mods = new Properties();
            this._curClassDef.addModification(name, mods);
        }
        attributes.remove(ATTRIBUTE_NAME);
        Enumeration<Object> enumeration = attributes.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = attributes.getProperty(key);
            mods.setProperty(key, value);
        }
        return "";
    }

    public String processNestedModification(Properties attributes) throws XDocletException {
        String prefix = OjbMemberTagsHandler.getMemberName() + "::";
        String name = prefix + attributes.getProperty(ATTRIBUTE_NAME);
        Properties mods = this._curClassDef.getModification(name);
        if (mods == null) {
            mods = new Properties();
            this._curClassDef.addModification(name, mods);
        }
        attributes.remove(ATTRIBUTE_NAME);
        Enumeration<Object> enumeration = attributes.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = attributes.getProperty(key);
            mods.setProperty(key, value);
        }
        return "";
    }

    public String createTorqueSchema(Properties attributes) throws XDocletException {
        String dbName = (String)OjbTagsHandler.getDocletContext().getConfigParam(CONFIG_PARAM_DATABASENAME);
        this._torqueModel = new TorqueModelDef(dbName, this._model);
        return "";
    }

    public void forAllTables(String template, Properties attributes) throws XDocletException {
        Iterator it = this._torqueModel.getTables();
        while (it.hasNext()) {
            this._curTableDef = (TableDef)it.next();
            this.generate(template);
        }
        this._curTableDef = null;
    }

    public void forAllColumns(String template, Properties attributes) throws XDocletException {
        Iterator it = this._curTableDef.getColumns();
        while (it.hasNext()) {
            this._curColumnDef = (ColumnDef)it.next();
            this.generate(template);
        }
        this._curColumnDef = null;
    }

    public void forAllForeignkeys(String template, Properties attributes) throws XDocletException {
        Iterator it = this._curTableDef.getForeignkeys();
        while (it.hasNext()) {
            this._curForeignkeyDef = (ForeignkeyDef)it.next();
            this.generate(template);
        }
        this._curForeignkeyDef = null;
    }

    public void forAllForeignkeyColumnPairs(String template, Properties attributes) throws XDocletException {
        for (int idx = 0; idx < this._curForeignkeyDef.getNumColumnPairs(); ++idx) {
            this._curPairLeft = this._curForeignkeyDef.getLocalColumn(idx);
            this._curPairRight = this._curForeignkeyDef.getRemoteColumn(idx);
            this.generate(template);
        }
        this._curPairLeft = null;
        this._curPairRight = null;
    }

    public void forAllIndices(String template, Properties attributes) throws XDocletException {
        boolean processUnique = TypeConversionUtil.stringToBoolean((String)attributes.getProperty(ATTRIBUTE_UNIQUE), (boolean)false);
        this._curIndexDef = this._curTableDef.getIndex(null);
        if (this._curIndexDef != null && processUnique == this._curIndexDef.isUnique()) {
            this.generate(template);
        }
        Iterator it = this._curTableDef.getIndices();
        while (it.hasNext()) {
            this._curIndexDef = (IndexDef)it.next();
            if (this._curIndexDef.isDefault() || processUnique != this._curIndexDef.isUnique()) continue;
            this.generate(template);
        }
        this._curIndexDef = null;
    }

    public void forAllIndexColumns(String template, Properties attributes) throws XDocletException {
        Iterator it = this._curIndexDef.getColumns();
        while (it.hasNext()) {
            this._curColumnDef = this._curTableDef.getColumn((String)it.next());
            this.generate(template);
        }
        this._curColumnDef = null;
    }

    public String name(Properties attributes) throws XDocletException {
        return this.getDefForLevel(attributes.getProperty(ATTRIBUTE_LEVEL)).getName();
    }

    public void ifHasName(String template, Properties attributes) throws XDocletException {
        String name = this.getDefForLevel(attributes.getProperty(ATTRIBUTE_LEVEL)).getName();
        if (name != null && name.length() > 0) {
            this.generate(template);
        }
    }

    public void ifHasProperty(String template, Properties attributes) throws XDocletException {
        String value = this.getPropertyValue(attributes.getProperty(ATTRIBUTE_LEVEL), attributes.getProperty(ATTRIBUTE_NAME));
        if (value != null) {
            this.generate(template);
        }
    }

    public void ifDoesntHaveProperty(String template, Properties attributes) throws XDocletException {
        String value = this.getPropertyValue(attributes.getProperty(ATTRIBUTE_LEVEL), attributes.getProperty(ATTRIBUTE_NAME));
        if (value == null) {
            this.generate(template);
        }
    }

    public String propertyValue(Properties attributes) throws XDocletException {
        String value = this.getPropertyValue(attributes.getProperty(ATTRIBUTE_LEVEL), attributes.getProperty(ATTRIBUTE_NAME));
        if (value == null) {
            value = attributes.getProperty(ATTRIBUTE_DEFAULT);
        }
        return value;
    }

    public void ifPropertyValueEquals(String template, Properties attributes) throws XDocletException {
        String value = this.getPropertyValue(attributes.getProperty(ATTRIBUTE_LEVEL), attributes.getProperty(ATTRIBUTE_NAME));
        String expected = attributes.getProperty(ATTRIBUTE_VALUE);
        if (value == null) {
            value = attributes.getProperty(ATTRIBUTE_DEFAULT);
        }
        if (expected.equals(value)) {
            this.generate(template);
        }
    }

    public void ifPropertyValueDoesntEqual(String template, Properties attributes) throws XDocletException {
        String value = this.getPropertyValue(attributes.getProperty(ATTRIBUTE_LEVEL), attributes.getProperty(ATTRIBUTE_NAME));
        String expected = attributes.getProperty(ATTRIBUTE_VALUE);
        if (value == null) {
            value = attributes.getProperty(ATTRIBUTE_DEFAULT);
        }
        if (!expected.equals(value)) {
            this.generate(template);
        }
    }

    public void forAllValuePairs(String template, Properties attributes) throws XDocletException {
        String name = attributes.getProperty(ATTRIBUTE_NAME, "attributes");
        String defaultValue = attributes.getProperty(ATTRIBUTE_DEFAULT_RIGHT, "");
        String attributePairs = this.getPropertyValue(attributes.getProperty(ATTRIBUTE_LEVEL), name);
        if (attributePairs == null || attributePairs.length() == 0) {
            return;
        }
        CommaListIterator it = new CommaListIterator(attributePairs);
        while (it.hasNext()) {
            String token = it.getNext();
            int pos = token.indexOf(61);
            if (pos >= 0) {
                this._curPairLeft = token.substring(0, pos);
                this._curPairRight = pos < token.length() - 1 ? token.substring(pos + 1) : defaultValue;
            } else {
                this._curPairLeft = token;
                this._curPairRight = defaultValue;
            }
            if (this._curPairLeft.length() <= 0) continue;
            this.generate(template);
        }
        this._curPairLeft = null;
        this._curPairRight = null;
    }

    public String pairLeft(Properties attributes) throws XDocletException {
        return this._curPairLeft;
    }

    public String pairRight(Properties attributes) throws XDocletException {
        return this._curPairRight;
    }

    private DefBase getDefForLevel(String level) {
        if ("class".equals(level)) {
            return this._curClassDef;
        }
        if (LEVEL_FIELD.equals(level)) {
            return this._curFieldDef;
        }
        if (LEVEL_REFERENCE.equals(level)) {
            return this._curReferenceDef;
        }
        if (LEVEL_COLLECTION.equals(level)) {
            return this._curCollectionDef;
        }
        if (LEVEL_OBJECT_CACHE.equals(level)) {
            return this._curObjectCacheDef;
        }
        if (LEVEL_INDEX_DESC.equals(level)) {
            return this._curIndexDescriptorDef;
        }
        if (LEVEL_TABLE.equals(level)) {
            return this._curTableDef;
        }
        if (LEVEL_COLUMN.equals(level)) {
            return this._curColumnDef;
        }
        if (LEVEL_FOREIGNKEY.equals(level)) {
            return this._curForeignkeyDef;
        }
        if (LEVEL_INDEX.equals(level)) {
            return this._curIndexDef;
        }
        if (LEVEL_PROCEDURE.equals(level)) {
            return this._curProcedureDef;
        }
        if (LEVEL_PROCEDURE_ARGUMENT.equals(level)) {
            return this._curProcedureArgumentDef;
        }
        return null;
    }

    private boolean isFeatureIgnored(String level) {
        return this.getDefForLevel(level).getBooleanProperty("ignore", false);
    }

    private String getPropertyValue(String level, String name) {
        return this.getDefForLevel(level).getProperty(name);
    }

    private ClassDescriptorDef ensureClassDef(XClass original) {
        String name = original.getQualifiedName();
        ClassDescriptorDef classDef = this._model.getClass(name);
        if (classDef == null) {
            classDef = new ClassDescriptorDef(original);
            this._model.addClass(classDef);
        }
        return classDef;
    }

    private void addDirectSubTypes(XClass type, ArrayList subTypes) {
        if (type.isInterface()) {
            if (type.getExtendingInterfaces() != null) {
                subTypes.addAll(type.getExtendingInterfaces());
            }
            if (type.getImplementingClasses() != null) {
                Collection declaredInterfaces = null;
                Iterator it = type.getImplementingClasses().iterator();
                while (it.hasNext()) {
                    XClass subType = (XClass)it.next();
                    if (subType instanceof AbstractClass) {
                        declaredInterfaces = ((AbstractClass)subType).getDeclaredInterfaces();
                        if (declaredInterfaces == null || !declaredInterfaces.contains(type)) continue;
                        subTypes.add(subType);
                        continue;
                    }
                    subTypes.add(subType);
                }
            }
        } else {
            subTypes.addAll(type.getDirectSubclasses());
        }
    }

    private String searchForPersistentSubType(XClass type) {
        ArrayList<XClass> queue = new ArrayList<XClass>();
        queue.add(type);
        while (!queue.isEmpty()) {
            XClass subType = (XClass)queue.get(0);
            queue.remove(0);
            if (this._model.hasClass(subType.getQualifiedName())) {
                return subType.getQualifiedName();
            }
            this.addDirectSubTypes(subType, queue);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

