/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.model;

import java.util.Iterator;
import java.util.Properties;
import xdoclet.modules.ojb.model.PropertyHelper;

public abstract class DefBase {
    private DefBase _owner;
    private String _name;
    private Properties _properties = new Properties();

    public DefBase(String name) {
        this._name = name;
    }

    public DefBase(DefBase src, String prefix) {
        this._name = prefix != null ? prefix + src._name : src._name;
        Iterator<Object> it = src._properties.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.setProperty(key, src._properties.getProperty(key));
        }
    }

    public DefBase getOwner() {
        return this._owner;
    }

    public String getName() {
        return this._name;
    }

    public String getProperty(String name) {
        return this._properties.getProperty(name);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return PropertyHelper.toBoolean(this._properties.getProperty(name), defaultValue);
    }

    public Iterator getPropertyNames() {
        return this._properties.keySet().iterator();
    }

    public void setOwner(DefBase owner) {
        this._owner = owner;
    }

    public void setProperty(String name, String value) {
        if (value == null || value.length() == 0) {
            this._properties.remove(name);
        } else {
            this._properties.setProperty(name, value);
        }
    }

    public boolean hasProperty(String name) {
        return this._properties.containsKey(name);
    }

    public void applyModifications(Properties mods) {
        Iterator<Object> it = mods.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = mods.getProperty(key);
            this.setProperty(key, value);
        }
    }

    public String toString() {
        return this.getName();
    }
}

