/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ojb.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.collections.SequencedHashMap;
import xdoclet.modules.ojb.model.ColumnDef;
import xdoclet.modules.ojb.model.DefBase;
import xdoclet.modules.ojb.model.ForeignkeyDef;
import xdoclet.modules.ojb.model.IndexDef;

public class TableDef
extends DefBase {
    private SequencedHashMap _columns = new SequencedHashMap();
    private ArrayList _indices = new ArrayList();
    private ArrayList _foreignkeys = new ArrayList();

    public TableDef(String name) {
        super(name);
    }

    public Iterator getColumns() {
        return this._columns.values().iterator();
    }

    public ColumnDef getColumn(String name) {
        return (ColumnDef)this._columns.get((Object)name);
    }

    public IndexDef getIndex(String name) {
        String realName = name == null ? "" : name;
        IndexDef def = null;
        Iterator it = this.getIndices();
        while (it.hasNext()) {
            def = (IndexDef)it.next();
            if (!def.getName().equals(realName)) continue;
            return def;
        }
        return null;
    }

    public Iterator getIndices() {
        return this._indices.iterator();
    }

    public ForeignkeyDef getForeignkey(String name, String tableName) {
        String realName = name == null ? "" : name;
        ForeignkeyDef def = null;
        Iterator it = this.getForeignkeys();
        while (it.hasNext()) {
            def = (ForeignkeyDef)it.next();
            if (!realName.equals(def.getName()) || !def.getTableName().equals(tableName)) continue;
            return def;
        }
        return null;
    }

    public Iterator getForeignkeys() {
        return this._foreignkeys.iterator();
    }

    public void addColumn(ColumnDef columnDef) {
        columnDef.setOwner(this);
        this._columns.put((Object)columnDef.getName(), (Object)columnDef);
    }

    public void addIndex(IndexDef indexDef) {
        indexDef.setOwner(this);
        this._indices.add(indexDef);
    }

    public void addForeignkey(ForeignkeyDef foreignkeyDef) {
        foreignkeyDef.setOwner(this);
        this._foreignkeys.add(foreignkeyDef);
    }

    public boolean hasForeignkey(String name) {
        String realName = name == null ? "" : name;
        ForeignkeyDef def = null;
        Iterator it = this.getForeignkeys();
        while (it.hasNext()) {
            def = (ForeignkeyDef)it.next();
            if (!realName.equals(def.getName())) continue;
            return true;
        }
        return false;
    }
}

