/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.HasExecutionListeners;
import org.activiti.bpmn.model.SubProcess;

public abstract class FlowElement
extends BaseElement
implements HasExecutionListeners {
    protected String name;
    protected String documentation;
    protected List<ActivitiListener> executionListeners = new ArrayList<ActivitiListener>();
    protected FlowElementsContainer parentContainer;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Override
    public List<ActivitiListener> getExecutionListeners() {
        return this.executionListeners;
    }

    @Override
    public void setExecutionListeners(List<ActivitiListener> executionListeners) {
        this.executionListeners = executionListeners;
    }

    @JsonIgnore
    public FlowElementsContainer getParentContainer() {
        return this.parentContainer;
    }

    @JsonIgnore
    public SubProcess getSubProcess() {
        SubProcess subProcess = null;
        if (this.parentContainer != null && this.parentContainer instanceof SubProcess) {
            subProcess = (SubProcess)this.parentContainer;
        }
        return subProcess;
    }

    public void setParentContainer(FlowElementsContainer parentContainer) {
        this.parentContainer = parentContainer;
    }

    @Override
    public abstract FlowElement clone();

    public void setValues(FlowElement otherElement) {
        super.setValues(otherElement);
        this.setName(otherElement.getName());
        this.setDocumentation(otherElement.getDocumentation());
        this.executionListeners = new ArrayList<ActivitiListener>();
        if (otherElement.getExecutionListeners() != null && !otherElement.getExecutionListeners().isEmpty()) {
            for (ActivitiListener listener : otherElement.getExecutionListeners()) {
                this.executionListeners.add(listener.clone());
            }
        }
    }
}

