/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.crystalball.simulator.impl;

import java.util.Map;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationEventHandler;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartProcessByIdEventHandler
implements SimulationEventHandler {
    private static Logger log = LoggerFactory.getLogger(StartProcessByIdEventHandler.class);
    protected String processToStartIdKey;
    protected String businessKey;
    protected String variablesKey;

    public StartProcessByIdEventHandler(String processToStartIdKey, String businessKey, String variablesKey) {
        this.processToStartIdKey = processToStartIdKey;
        this.businessKey = businessKey;
        this.variablesKey = variablesKey;
    }

    @Override
    public void init() {
    }

    @Override
    public void handle(SimulationEvent event) {
        String processDefinitionId = (String)event.getProperty(this.processToStartIdKey);
        String businessKey = (String)event.getProperty(this.businessKey);
        Map variables = (Map)event.getProperty(this.variablesKey);
        log.debug("Starting new processDefId[{}] businessKey[{}] with variables[{}]", new Object[]{processDefinitionId, businessKey, variables});
        SimulationRunContext.getRuntimeService().startProcessInstanceById(processDefinitionId, businessKey, variables);
    }
}

