/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.Date;
import java.util.List;
import org.activiti.crystalball.simulator.SimulationEvent;
import org.activiti.crystalball.simulator.SimulationRunContext;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.AcquireJobsRunnableImpl;
import org.activiti.engine.impl.jobexecutor.AcquiredJobs;
import org.activiti.engine.impl.jobexecutor.GetUnlockedTimersByDuedateCmd;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationAcquireJobsRunnable
extends AcquireJobsRunnableImpl {
    private static Logger log = LoggerFactory.getLogger((String)SimulationAcquireJobsRunnable.class.getName());

    public SimulationAcquireJobsRunnable(JobExecutor jobExecutor) {
        super(jobExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        CommandExecutor commandExecutor = this.jobExecutor.getCommandExecutor();
        this.isWaiting.set(false);
        int maxJobsPerAcquisition = this.jobExecutor.getMaxJobsPerAcquisition();
        try {
            AcquiredJobs acquiredJobs = (AcquiredJobs)commandExecutor.execute(this.jobExecutor.getAcquireJobsCmd());
            for (List jobIds : acquiredJobs.getJobIdBatches()) {
                this.jobExecutor.executeJobs(jobIds);
            }
            this.millisToWait = this.jobExecutor.getWaitTimeInMillis();
            int jobsAcquired = acquiredJobs.getJobIdBatches().size();
            if (jobsAcquired < maxJobsPerAcquisition) {
                long millisTillNextTimer;
                this.isJobAdded = false;
                Date duedate = new Date(SimulationRunContext.getClock().getCurrentTime().getTime() + this.millisToWait);
                List nextTimers = (List)commandExecutor.execute((Command)new GetUnlockedTimersByDuedateCmd(duedate, new Page(0, 1)));
                if (!nextTimers.isEmpty() && (millisTillNextTimer = ((TimerEntity)nextTimers.get(0)).getDuedate().getTime() - SimulationRunContext.getClock().getCurrentTime().getTime()) < this.millisToWait && millisTillNextTimer != 0L) {
                    this.millisToWait = millisTillNextTimer;
                }
            } else {
                this.millisToWait = 0L;
            }
        }
        catch (ActivitiOptimisticLockingException optimisticLockingException) {
            log.trace("Optimistic locking exception during job acquisition. If you have multiple job executors running against the same database, this exception means that this thread tried to acquire a job, which already was acquired by another job executor acquisition thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple job executor acquisition threads running against the same database. Exception message: " + optimisticLockingException.getMessage());
        }
        catch (Exception e) {
            log.error("exception during job acquisition: " + e.getMessage(), (Throwable)e);
            this.millisToWait = this.jobExecutor.getWaitTimeInMillis();
        }
        if (this.millisToWait > 0L && !this.isJobAdded) {
            log.trace("job acquisition thread sleeping for " + this.millisToWait + " millis");
            Object e = this.MONITOR;
            synchronized (e) {
                if (!this.isInterrupted) {
                    this.isWaiting.set(true);
                    SimulationEvent event = new SimulationEvent.Builder("ACQUIRE_JOB_NOTIFICATION_EVENT").simulationTime(SimulationRunContext.getClock().getCurrentTime().getTime() + this.millisToWait).property((Object)this).build();
                    SimulationRunContext.getEventCalendar().addEvent(event);
                }
            }
            log.trace("job acquisition thread woke up");
        }
        SimulationEvent event = new SimulationEvent.Builder("ACQUIRE_JOB_NOTIFICATION_EVENT").simulationTime(SimulationRunContext.getClock().getCurrentTime().getTime()).property((Object)this).build();
        SimulationRunContext.getEventCalendar().addEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        this.isJobAdded = true;
        if (this.isWaiting.compareAndSet(true, false)) {
            Object object = this.MONITOR;
            synchronized (object) {
                SimulationEvent event = new SimulationEvent.Builder("ACQUIRE_JOB_NOTIFICATION_EVENT").simulationTime(SimulationRunContext.getClock().getCurrentTime().getTime()).property((Object)this).build();
                SimulationRunContext.getEventCalendar().addEvent(event);
            }
        }
    }
}

