/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.activiti.explorer.ui;

import com.vaadin.terminal.Resource;
import com.vaadin.terminal.ThemeResource;


/**
 * Contains statically created {@link Resource} instances for all the images.
 * 
 * @author Joram Barrez
 */
public class Images {
  
  // General
  public static final Resource WARNING = new ThemeResource("img/warning.png");
  public static final Resource DELETE = new ThemeResource("img/delete.png");
  public static final Resource EXECUTE = new ThemeResource("img/execute.png");
  public static final Resource USER_ADD = new ThemeResource("img/user_add.png");
  public static final Resource SUCCESS = new ThemeResource("img/tick.png");
  public static final Resource EDIT = new ThemeResource("img/edit.png");
  public static final Resource SAVE = new ThemeResource("img/save.png");
  public static final Resource MAGNIFIER_16 = new ThemeResource("img/magnifier-16.png");
  
  public static final Resource MAIN_MENU_TASKS = new ThemeResource("img/mm-tasks.png");
  public static final Resource MAIN_MENU_PROCESS = new ThemeResource("img/mm-process.png");
  public static final Resource MAIN_MENU_MANAGE = new ThemeResource("img/mm-manage.png");
  public static final Resource MAIN_MENU_REPORTS = new ThemeResource("img/mm-reports.png");
  
  // Task
  public static final Resource TASK_16 =  new ThemeResource("img/task-16.png");;
  public static final Resource TASK_22 = new ThemeResource("img/task-22.png");
  public static final Resource TASK_50 = new ThemeResource("img/task-50.png");
  public static final Resource TASK_FINISHED_22 = new ThemeResource("img/task-finished-22.png");
  public static final Resource TASK_DUE_DATE_16 = new ThemeResource("img/duedate-16.png");
  
  // Accounts
  public static final Resource SKYPE = new ThemeResource("img/skype.png");
  public static final Resource GOOGLE = new ThemeResource("img/google.png");
  public static final Resource ALFRESCO = new ThemeResource("img/alfresco.gif");
  public static final Resource IMAP = new ThemeResource("img/imap.png");
  
  // Database
  public static final Resource DATABASE_HISTORY = new ThemeResource("img/database-history-22.png");
  public static final Resource DATABASE_IDENTITY = new ThemeResource("img/database-identity-22.png");
  public static final Resource DATABASE_REPOSITORY = new ThemeResource("img/database-repository-22.png");
  public static final Resource DATABASE_RUNTIME = new ThemeResource("img/database-runtime-22.png");
  public static final Resource DATABASE_50 = new ThemeResource("img/database-50.png");
  public static final Resource DATABASE_22 = new ThemeResource("img/database-22.png");
  
  // Deployment
  public static final Resource DEPLOYMENT_50 = new ThemeResource("img/deployment-50.png");
  public static final Resource DEPLOYMENT_22 = new ThemeResource("img/deployment-22.png");
  
  // Jobs
  public static final Resource JOB_50 = new ThemeResource("img/job-50.png");
  public static final Resource JOB_22 = new ThemeResource("img/job-22.png");
  
  // User administration
  public static final Resource USER_16 = new ThemeResource("img/user-16.png");
  public static final Resource USER_22 = new ThemeResource("img/user-22.png");
  public static final Resource USER_32 = new ThemeResource("img/user-32.png");
  public static final Resource USER_50 = new ThemeResource("img/user-50.png");
  
  public static final Resource GROUP_16 = new ThemeResource("img/group-16.png");
  public static final Resource GROUP_22 = new ThemeResource("img/group-22.png");
  public static final Resource GROUP_32 = new ThemeResource("img/group-32.png");
  public static final Resource GROUP_50 = new ThemeResource("img/group-50.png");
  
  // Related content
  public static final Resource RELATED_CONTENT_URL = new ThemeResource("img/page_white_world.png");
  public static final Resource RELATED_CONTENT_FILE = new ThemeResource("img/page_white_get.png");
  public static final Resource RELATED_CONTENT_PDF = new ThemeResource("img/page_white_acrobat.png");
  public static final Resource RELATED_CONTENT_PICTURE = new ThemeResource("img/picture.png");

  // Process
  public static final Resource PROCESS_50 = new ThemeResource("img/process-50.png");
  public static final Resource PROCESS_22 = new ThemeResource("img/process-22.png");
  public static final Resource PROCESS_EDITOR_BPMN = new ThemeResource("img/button-bpmn-48.png");
  public static final Resource PROCESS_EDITOR_TABLE = new ThemeResource("img/button-table-48.png");
  
  // Reports
  public static final Resource REPORT_50 = new ThemeResource("img/report-50.png");
  public static final Resource REPORT_22 = new ThemeResource("img/report-22.png");
  
}
