/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.ui;

import com.vaadin.terminal.ErrorMessage;
import com.vaadin.terminal.UserError;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Form;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import org.activiti.editor.constants.ModelDataJsonConstants;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.custom.PopupWindow;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

public class CopyModelPopupWindow
extends PopupWindow
implements ModelDataJsonConstants {
    private static final long serialVersionUID = 1L;
    protected Model modelData;
    protected I18nManager i18nManager;
    protected VerticalLayout windowLayout;
    protected Form form;
    protected TextField nameTextField;
    protected TextArea descriptionTextArea;
    protected transient RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();

    public CopyModelPopupWindow(Model model) {
        this.modelData = model;
        this.windowLayout = (VerticalLayout)this.getContent();
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.initWindow();
        this.addFields();
        this.addButtons();
    }

    protected void initWindow() {
        this.windowLayout.setSpacing(true);
        this.addStyleName("light");
        this.setModal(true);
        this.setWidth("400px");
        this.setHeight("390px");
        this.center();
        this.setCaption(this.i18nManager.getMessage("process.copy.popup.caption"));
    }

    protected void addFields() {
        this.form = new Form();
        this.form.setCaption(this.i18nManager.getMessage("process.copy.popup.caption"));
        this.form.getLayout().setMargin(true);
        this.nameTextField = new TextField(this.i18nManager.getMessage("task.name"));
        this.nameTextField.setWidth(20.0f, 3);
        this.nameTextField.setRequired(true);
        this.nameTextField.setValue((Object)this.modelData.getName());
        this.form.getLayout().addComponent((Component)this.nameTextField);
        this.nameTextField.focus();
        this.descriptionTextArea = new TextArea(this.i18nManager.getMessage("task.description"));
        this.descriptionTextArea.setRows(8);
        this.descriptionTextArea.setWidth(20.0f, 3);
        this.form.getLayout().addComponent((Component)this.descriptionTextArea);
        this.addComponent((Component)this.form);
        Label emptySpace = new Label("&nbsp;", 3);
        this.addComponent((Component)emptySpace);
    }

    protected void addButtons() {
        Button cancelButton = new Button(this.i18nManager.getMessage("button.cancel"));
        cancelButton.addStyleName("small");
        cancelButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CopyModelPopupWindow.this.close();
            }
        });
        Button createButton = new Button(this.i18nManager.getMessage("process.new.popup.create.button"));
        createButton.addStyleName("small");
        createButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                if (StringUtils.isEmpty((CharSequence)((String)CopyModelPopupWindow.this.nameTextField.getValue()))) {
                    CopyModelPopupWindow.this.form.setComponentError((ErrorMessage)new UserError("The name field is required."));
                    return;
                }
                Model newModelData = CopyModelPopupWindow.this.repositoryService.newModel();
                ObjectNode modelObjectNode = new ObjectMapper().createObjectNode();
                modelObjectNode.put("name", (String)CopyModelPopupWindow.this.nameTextField.getValue());
                String description = null;
                description = StringUtils.isNotEmpty((CharSequence)((String)CopyModelPopupWindow.this.descriptionTextArea.getValue())) ? (String)CopyModelPopupWindow.this.descriptionTextArea.getValue() : "";
                modelObjectNode.put("description", description);
                newModelData.setMetaInfo(modelObjectNode.toString());
                newModelData.setName((String)CopyModelPopupWindow.this.nameTextField.getValue());
                CopyModelPopupWindow.this.repositoryService.saveModel(newModelData);
                CopyModelPopupWindow.this.repositoryService.addModelEditorSource(newModelData.getId(), CopyModelPopupWindow.this.repositoryService.getModelEditorSource(CopyModelPopupWindow.this.modelData.getId()));
                CopyModelPopupWindow.this.repositoryService.addModelEditorSourceExtra(newModelData.getId(), CopyModelPopupWindow.this.repositoryService.getModelEditorSourceExtra(CopyModelPopupWindow.this.modelData.getId()));
                CopyModelPopupWindow.this.close();
                ExplorerApp.get().getViewManager().showEditorProcessDefinitionPage(newModelData.getId());
            }
        });
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setSpacing(true);
        buttonLayout.addComponent((Component)cancelButton);
        buttonLayout.addComponent((Component)createButton);
        this.addComponent((Component)buttonLayout);
        this.windowLayout.setComponentAlignment((Component)buttonLayout, Alignment.BOTTOM_RIGHT);
    }
}

