/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.identity;

import com.vaadin.data.Container;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Table;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.data.LazyLoadingContainer;
import org.activiti.explorer.ui.Images;
import org.activiti.explorer.ui.custom.ConfirmationDialogPopupWindow;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.custom.SelectUsersPopupWindow;
import org.activiti.explorer.ui.event.ConfirmationEvent;
import org.activiti.explorer.ui.event.ConfirmationEventListener;
import org.activiti.explorer.ui.event.SubmitEvent;
import org.activiti.explorer.ui.event.SubmitEventListener;
import org.activiti.explorer.ui.management.identity.GroupMembersQuery;
import org.activiti.explorer.ui.management.identity.GroupPage;
import org.activiti.explorer.ui.management.identity.MemberShipChangeListener;
import org.activiti.explorer.ui.management.identity.NewGroupPopupWindow;

public class GroupDetailPanel
extends DetailPanel
implements MemberShipChangeListener {
    private static final long serialVersionUID = 1L;
    protected transient IdentityService identityService;
    protected I18nManager i18nManager;
    protected GroupPage groupPage;
    protected Group group;
    protected VerticalLayout panelLayout;
    protected boolean editingDetails;
    protected HorizontalLayout detailLayout;
    protected GridLayout detailsGrid;
    protected TextField nameTextField;
    protected ComboBox typeCombobox;
    protected HorizontalLayout membersLayout;
    protected Table membersTable;
    protected Label noMembersTable;

    public GroupDetailPanel(GroupPage groupPage, String groupId) {
        this.groupPage = groupPage;
        this.identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
        this.group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.init();
    }

    protected void init() {
        this.setSizeFull();
        this.addStyleName("light");
        this.initPageTitle();
        this.initGroupDetails();
        this.initMembers();
        this.initActions();
    }

    protected void initActions() {
        Button createGroupButton = new Button(this.i18nManager.getMessage("group.create"));
        createGroupButton.setIcon(Images.GROUP_16);
        createGroupButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                NewGroupPopupWindow popup = new NewGroupPopupWindow();
                ExplorerApp.get().getViewManager().showPopupWindow(popup);
            }
        });
        this.groupPage.getToolBar().removeAllButtons();
        this.groupPage.getToolBar().addButton(createGroupButton);
    }

    protected void initPageTitle() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setWidth(100.0f, 8);
        layout.addStyleName("title-block");
        layout.setSpacing(true);
        layout.setMargin(false, false, true, false);
        this.addDetailComponent((Component)layout);
        Embedded groupImage = new Embedded(null, Images.GROUP_50);
        layout.addComponent((Component)groupImage);
        Label groupName = new Label(this.getGroupName(this.group));
        groupName.setSizeUndefined();
        groupName.addStyleName("h2");
        layout.addComponent((Component)groupName);
        layout.setComponentAlignment((Component)groupName, Alignment.MIDDLE_LEFT);
        layout.setExpandRatio((Component)groupName, 1.0f);
    }

    protected String getGroupName(Group theGroup) {
        if (theGroup.getName() == null) {
            return theGroup.getId();
        }
        return this.group.getName();
    }

    protected void initGroupDetails() {
        Label groupDetailsHeader = new Label(this.i18nManager.getMessage("group.header.details"));
        groupDetailsHeader.addStyleName("h3");
        groupDetailsHeader.addStyleName("block-holder");
        this.addDetailComponent((Component)groupDetailsHeader);
        this.detailLayout = new HorizontalLayout();
        this.detailLayout.setSpacing(true);
        this.detailLayout.setMargin(true, false, true, false);
        this.addDetailComponent((Component)this.detailLayout);
        this.populateGroupDetails();
    }

    protected void populateGroupDetails() {
        this.initGroupProperties();
        this.initGroupActions();
    }

    protected void initGroupProperties() {
        this.detailsGrid = new GridLayout(2, 3);
        this.detailsGrid.setSpacing(true);
        this.detailLayout.setMargin(true, true, true, false);
        this.detailLayout.addComponent((Component)this.detailsGrid);
        Label idLabel = new Label(this.i18nManager.getMessage("group.id") + ": ");
        idLabel.addStyleName("bold");
        this.detailsGrid.addComponent((Component)idLabel);
        Label idValueLabel = new Label(this.group.getId());
        this.detailsGrid.addComponent((Component)idValueLabel);
        Label nameLabel = new Label(this.i18nManager.getMessage("group.name") + ": ");
        nameLabel.addStyleName("bold");
        this.detailsGrid.addComponent((Component)nameLabel);
        if (!this.editingDetails) {
            Label nameValueLabel = new Label(this.group.getName());
            this.detailsGrid.addComponent((Component)nameValueLabel);
        } else {
            this.nameTextField = new TextField(null, this.group.getName());
            this.detailsGrid.addComponent((Component)this.nameTextField);
        }
        Label typeLabel = new Label(this.i18nManager.getMessage("group.type") + ": ");
        typeLabel.addStyleName("bold");
        this.detailsGrid.addComponent((Component)typeLabel);
        if (!this.editingDetails) {
            Label typeValueLabel = new Label(this.group.getType());
            this.detailsGrid.addComponent((Component)typeValueLabel);
        } else {
            this.typeCombobox = new ComboBox(null, Arrays.asList("assignment", "security-role"));
            this.typeCombobox.setNullSelectionAllowed(false);
            this.typeCombobox.setInvalidAllowed(false);
            this.typeCombobox.select((Object)this.group.getType());
            this.detailsGrid.addComponent((Component)this.typeCombobox);
        }
    }

    protected void initGroupActions() {
        VerticalLayout actionsLayout = new VerticalLayout();
        actionsLayout.setSpacing(true);
        actionsLayout.setMargin(false, false, false, true);
        this.detailLayout.addComponent((Component)actionsLayout);
        if (this.editingDetails) {
            this.initSaveButton(actionsLayout);
        } else {
            this.initEditButton(actionsLayout);
            this.initDeleteButton(actionsLayout);
        }
    }

    protected void initEditButton(VerticalLayout actionsLayout) {
        Button editButton = new Button(this.i18nManager.getMessage("user.edit"));
        editButton.addStyleName("small");
        actionsLayout.addComponent((Component)editButton);
        editButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                GroupDetailPanel.this.editingDetails = true;
                GroupDetailPanel.this.detailLayout.removeAllComponents();
                GroupDetailPanel.this.populateGroupDetails();
            }
        });
    }

    protected void initSaveButton(VerticalLayout actionsLayout) {
        Button saveButton = new Button(this.i18nManager.getMessage("user.save"));
        saveButton.addStyleName("small");
        actionsLayout.addComponent((Component)saveButton);
        saveButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                String originalName = GroupDetailPanel.this.group.getName();
                if (GroupDetailPanel.this.nameTextField.getValue() != null) {
                    GroupDetailPanel.this.group.setName(GroupDetailPanel.this.nameTextField.getValue().toString());
                    GroupDetailPanel.this.group.setType(GroupDetailPanel.this.typeCombobox.getValue().toString());
                }
                GroupDetailPanel.this.identityService.saveGroup(GroupDetailPanel.this.group);
                GroupDetailPanel.this.editingDetails = false;
                GroupDetailPanel.this.detailLayout.removeAllComponents();
                GroupDetailPanel.this.populateGroupDetails();
                if (originalName != null && !originalName.equals(GroupDetailPanel.this.group.getName()) || originalName == null && GroupDetailPanel.this.group.getName() != null) {
                    GroupDetailPanel.this.groupPage.notifyGroupChanged(GroupDetailPanel.this.group.getId());
                }
            }
        });
    }

    protected void initDeleteButton(VerticalLayout actionsLayout) {
        Button deleteButton = new Button(this.i18nManager.getMessage("group.delete"));
        deleteButton.addStyleName("small");
        actionsLayout.addComponent((Component)deleteButton);
        deleteButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                ConfirmationDialogPopupWindow confirmPopup = new ConfirmationDialogPopupWindow(GroupDetailPanel.this.i18nManager.getMessage("group.confirm.delete", GroupDetailPanel.this.group.getId()));
                confirmPopup.addListener(new ConfirmationEventListener(){

                    @Override
                    protected void rejected(ConfirmationEvent event) {
                    }

                    @Override
                    protected void confirmed(ConfirmationEvent event) {
                        GroupDetailPanel.this.identityService.deleteGroup(GroupDetailPanel.this.group.getId());
                        GroupDetailPanel.this.groupPage.refreshSelectNext();
                    }
                });
                ExplorerApp.get().getViewManager().showPopupWindow(confirmPopup);
            }
        });
    }

    protected void initMembers() {
        HorizontalLayout membersHeader = new HorizontalLayout();
        membersHeader.setSpacing(true);
        membersHeader.setWidth(100.0f, 8);
        membersHeader.addStyleName("block-holder");
        this.addDetailComponent((Component)membersHeader);
        this.initMembersTitle(membersHeader);
        this.initAddMembersButton(membersHeader);
        this.membersLayout = new HorizontalLayout();
        this.membersLayout.setWidth(100.0f, 8);
        this.addDetailComponent((Component)this.membersLayout);
        this.initMembersTable();
    }

    protected void initMembersTitle(HorizontalLayout membersHeader) {
        Label usersHeader = new Label(this.i18nManager.getMessage("group.header.users"));
        usersHeader.addStyleName("h3");
        membersHeader.addComponent((Component)usersHeader);
    }

    protected void initAddMembersButton(HorizontalLayout membersHeader) {
        Button addButton = new Button();
        addButton.addStyleName("add");
        membersHeader.addComponent((Component)addButton);
        membersHeader.setComponentAlignment((Component)addButton, Alignment.MIDDLE_RIGHT);
        addButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                final SelectUsersPopupWindow selectUsersPopup = new SelectUsersPopupWindow(GroupDetailPanel.this.i18nManager.getMessage("group.select.members", GroupDetailPanel.this.group.getId()), true, false, GroupDetailPanel.this.getCurrentMembers());
                ExplorerApp.get().getViewManager().showPopupWindow(selectUsersPopup);
                selectUsersPopup.addListener(new SubmitEventListener(){

                    @Override
                    protected void submitted(SubmitEvent event) {
                        Collection<String> userIds = selectUsersPopup.getSelectedUserIds();
                        if (userIds.size() > 0) {
                            for (String userId : userIds) {
                                GroupDetailPanel.this.identityService.createMembership(userId, GroupDetailPanel.this.group.getId());
                            }
                            GroupDetailPanel.this.notifyMembershipChanged();
                        }
                    }

                    @Override
                    protected void cancelled(SubmitEvent event) {
                    }
                });
            }
        });
    }

    protected List<String> getCurrentMembers() {
        List users = this.identityService.createUserQuery().memberOfGroup(this.group.getId()).list();
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            userIds.add(user.getId());
        }
        return userIds;
    }

    protected void initMembersTable() {
        GroupMembersQuery query = new GroupMembersQuery(this.group.getId(), this);
        if (query.size() > 0) {
            this.membersTable = new Table();
            this.membersTable.setWidth(100.0f, 8);
            this.membersTable.setHeight(400.0f, 0);
            this.membersTable.setEditable(false);
            this.membersTable.setSelectable(false);
            this.membersTable.setSortDisabled(false);
            LazyLoadingContainer container = new LazyLoadingContainer(query, 30);
            this.membersTable.setContainerDataSource((Container)container);
            this.membersTable.addContainerProperty((Object)"id", Button.class, null);
            this.membersTable.addContainerProperty((Object)"firstName", String.class, null);
            this.membersTable.addContainerProperty((Object)"lastName", String.class, null);
            this.membersTable.addContainerProperty((Object)"email", String.class, null);
            this.membersTable.addContainerProperty((Object)"actions", Component.class, null);
            this.membersLayout.addComponent((Component)this.membersTable);
        } else {
            this.noMembersTable = new Label(this.i18nManager.getMessage("group.no.members"));
            this.membersLayout.addComponent((Component)this.noMembersTable);
        }
    }

    @Override
    public void notifyMembershipChanged() {
        this.membersLayout.removeAllComponents();
        this.initMembersTable();
    }
}

