/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.login;

import com.vaadin.ui.Component;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.LoginForm;
import java.io.IOException;
import java.io.InputStream;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngines;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.NotificationManager;
import org.activiti.explorer.ViewManager;
import org.activiti.explorer.identity.LoggedInUser;
import org.activiti.explorer.ui.login.ExplorerLoginForm;
import org.activiti.explorer.ui.login.LoginHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginPage
extends CustomLayout {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(LoginPage.class);
    protected transient IdentityService identityService = ProcessEngines.getDefaultProcessEngine().getIdentityService();
    protected I18nManager i18nManager;
    protected ViewManager viewManager;
    protected NotificationManager notificationManager;
    protected LoginHandler loginHandler;

    public LoginPage() {
        InputStream loginHtmlStream = ((Object)((Object)this)).getClass().getResourceAsStream("/VAADIN/themes/activiti/layouts/login.html");
        if (loginHtmlStream != null) {
            try {
                this.initTemplateContentsFromInputStream(loginHtmlStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Error while loading login page template from classpath resource", e);
            }
        } else {
            this.setTemplateName("login");
        }
        this.i18nManager = ExplorerApp.get().getI18nManager();
        this.viewManager = ExplorerApp.get().getViewManager();
        this.notificationManager = ExplorerApp.get().getNotificationManager();
        this.loginHandler = ExplorerApp.get().getLoginHandler();
        this.addStyleName("login-general");
        this.initUi();
    }

    protected void initUi() {
        ExplorerLoginForm loginForm = new ExplorerLoginForm();
        this.addComponent((Component)loginForm, "login-content");
        loginForm.addListener(new ActivitiLoginListener());
    }

    protected void refreshUi() {
        this.removeAllComponents();
        this.initUi();
    }

    class ActivitiLoginListener
    implements LoginForm.LoginListener {
        private static final long serialVersionUID = 1L;

        ActivitiLoginListener() {
        }

        public void onLogin(LoginForm.LoginEvent event) {
            try {
                String userName = event.getLoginParameter("username");
                String password = event.getLoginParameter("password");
                LoggedInUser loggedInUser = LoginPage.this.loginHandler.authenticate(userName, password);
                if (loggedInUser != null) {
                    ExplorerApp.get().setUser(loggedInUser);
                    LoginPage.this.viewManager.showDefaultPage();
                } else {
                    LoginPage.this.refreshUi();
                    LoginPage.this.notificationManager.showErrorNotification("login.failed.header", LoginPage.this.i18nManager.getMessage("login.failed.invalid"));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error at login", (Throwable)e);
            }
        }
    }
}

