/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task.data;

import com.vaadin.data.Item;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.data.AbstractLazyLoadingQuery;
import org.activiti.explorer.ui.task.data.TaskListItem;

public class ArchivedListQuery
extends AbstractLazyLoadingQuery {
    protected String userId = ExplorerApp.get().getLoggedInUser().getId();
    protected transient HistoryService historyService = ProcessEngines.getDefaultProcessEngine().getHistoryService();

    @Override
    public int size() {
        return (int)this.createQuery().count();
    }

    @Override
    public List<Item> loadItems(int start, int count) {
        List historicTaskInstances = this.createQuery().listPage(start, count);
        ArrayList<Item> items = new ArrayList<Item>();
        for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
            items.add((Item)new TaskListItem(historicTaskInstance));
        }
        return items;
    }

    @Override
    public Item loadSingleResult(String id) {
        return new TaskListItem((HistoricTaskInstance)((HistoricTaskInstanceQuery)this.createQuery().taskId(id)).singleResult());
    }

    @Override
    public void setSorting(Object[] propertyIds, boolean[] ascending) {
        throw new UnsupportedOperationException();
    }

    protected HistoricTaskInstanceQuery createQuery() {
        return ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskOwner(this.userId)).finished();
    }
}

