/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.ui;

import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.activiti.editor.ui.ImageStreamSource;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorProcessDefinitionInfoComponent
extends VerticalLayout {
    protected static final Logger LOGGER = LoggerFactory.getLogger(EditorProcessDefinitionInfoComponent.class);
    private static final long serialVersionUID = 1L;
    protected transient RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected Model modelData;
    protected HorizontalLayout timeDetails;
    protected VerticalLayout processImageContainer;

    public EditorProcessDefinitionInfoComponent(Model model) {
        this.modelData = model;
        this.addStyleName("block-holder");
        this.initImage();
    }

    protected void initImage() {
        this.processImageContainer = new VerticalLayout();
        Label processTitle = new Label(this.i18nManager.getMessage("process.header.diagram"));
        processTitle.addStyleName("h3");
        this.processImageContainer.addComponent((Component)processTitle);
        StreamResource.StreamSource streamSource = null;
        final byte[] editorSourceExtra = this.repositoryService.getModelEditorSourceExtra(this.modelData.getId());
        if (editorSourceExtra != null) {
            streamSource = new StreamResource.StreamSource(){
                private static final long serialVersionUID = 1L;

                public InputStream getStream() {
                    ByteArrayInputStream inStream = null;
                    try {
                        inStream = new ByteArrayInputStream(editorSourceExtra);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error reading PNG in StreamSource", (Throwable)e);
                    }
                    return inStream;
                }
            };
        }
        if (streamSource != null) {
            Embedded embedded = new Embedded(null, (Resource)new ImageStreamSource(streamSource, ExplorerApp.get()));
            embedded.setType(1);
            embedded.setSizeUndefined();
            Panel imagePanel = new Panel();
            imagePanel.addStyleName("light");
            imagePanel.setWidth(100.0f, 8);
            imagePanel.setHeight(700.0f, 0);
            HorizontalLayout panelLayout = new HorizontalLayout();
            panelLayout.setSizeUndefined();
            imagePanel.setContent((ComponentContainer)panelLayout);
            imagePanel.addComponent((Component)embedded);
            this.processImageContainer.addComponent((Component)imagePanel);
        } else {
            Label noImageAvailable = new Label(this.i18nManager.getMessage("process.no.diagram"));
            this.processImageContainer.addComponent((Component)noImageAvailable);
        }
        this.addComponent((Component)this.processImageContainer);
    }

    protected void addEmptySpace(ComponentContainer container) {
        Label emptySpace = new Label("&nbsp;", 3);
        emptySpace.setSizeUndefined();
        container.addComponent((Component)emptySpace);
    }
}

